/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.expressions.Expression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Evolving
public final class Column
implements Expression {
    private final String[] names;

    public Column(String string) {
        this.names = new String[]{string};
    }

    public Column(String[] stringArray) {
        this.names = stringArray;
    }

    public String[] getNames() {
        return this.names;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return "column(" + Column.quoteColumnPath(this.names) + ")";
    }

    public Column appendNestedField(String string) {
        String[] stringArray = new String[this.names.length + 1];
        System.arraycopy(this.names, 0, stringArray, 0, this.names.length);
        stringArray[this.names.length] = string;
        return new Column(stringArray);
    }

    private static String quoteColumnPath(String[] stringArray) {
        return Arrays.stream(stringArray).map(string -> String.format("`%s`", string.replace("`", "``"))).collect(Collectors.joining("."));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Column column = (Column)object;
        return Arrays.equals(this.names, column.getNames());
    }

    public int hashCode() {
        return Arrays.hashCode(this.names);
    }
}

