/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.types.DataTypeJsonSerDe;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TransactionStateRow
extends GenericRow {
    private static final StructType SCHEMA = new StructType().add("logicalSchemaString", StringType.STRING).add("partitionColumns", new ArrayType(StringType.STRING, false)).add("configuration", new MapType(StringType.STRING, StringType.STRING, false)).add("tablePath", StringType.STRING);
    private static final Map<String, Integer> COL_NAME_TO_ORDINAL = IntStream.range(0, SCHEMA.length()).boxed().collect(Collectors.toMap(n -> SCHEMA.at((int)n).getName(), n -> n));

    public static TransactionStateRow of(Metadata metadata, String string) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(COL_NAME_TO_ORDINAL.get("logicalSchemaString"), metadata.getSchemaString());
        hashMap.put(COL_NAME_TO_ORDINAL.get("partitionColumns"), metadata.getPartitionColumns());
        hashMap.put(COL_NAME_TO_ORDINAL.get("configuration"), metadata.getConfigurationMapValue());
        hashMap.put(COL_NAME_TO_ORDINAL.get("tablePath"), string);
        return new TransactionStateRow(hashMap);
    }

    private TransactionStateRow(HashMap<Integer, Object> hashMap) {
        super(SCHEMA, hashMap);
    }

    public static StructType getLogicalSchema(Engine engine, Row row) {
        String string = row.getString(COL_NAME_TO_ORDINAL.get("logicalSchemaString"));
        return DataTypeJsonSerDe.deserializeStructType(string);
    }

    public static Map<String, String> getConfiguration(Row row) {
        return VectorUtils.toJavaMap(row.getMap(COL_NAME_TO_ORDINAL.get("configuration")));
    }

    public static boolean isIcebergCompatV2Enabled(Row row) {
        return Boolean.parseBoolean(TransactionStateRow.getConfiguration(row).getOrDefault(TableConfig.ICEBERG_COMPAT_V2_ENABLED.getKey(), "false"));
    }

    public static List<String> getPartitionColumnsList(Row row) {
        return VectorUtils.toJavaList(row.getArray(COL_NAME_TO_ORDINAL.get("partitionColumns")));
    }

    public static String getTablePath(Row row) {
        return row.getString(COL_NAME_TO_ORDINAL.get("tablePath"));
    }
}

