/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.model;

import io.dekorate.servicebinding.model.Application;
import io.dekorate.servicebinding.model.ApplicationBuilder;
import io.dekorate.servicebinding.model.ApplicationFluent;
import io.dekorate.servicebinding.model.CustomEnvVar;
import io.dekorate.servicebinding.model.CustomEnvVarBuilder;
import io.dekorate.servicebinding.model.CustomEnvVarFluent;
import io.dekorate.servicebinding.model.Service;
import io.dekorate.servicebinding.model.ServiceBindingSpec;
import io.dekorate.servicebinding.model.ServiceBuilder;
import io.dekorate.servicebinding.model.ServiceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceBindingSpecFluent<A extends ServiceBindingSpecFluent<A>>
extends BaseFluent<A> {
    private ApplicationBuilder application;
    private ArrayList<ServiceBuilder> services;
    private String envVarPrefix;
    private boolean detectBindingResources;
    private boolean bindAsFiles;
    private String mountPath;
    private ArrayList<CustomEnvVarBuilder> customEnvVar;

    public ServiceBindingSpecFluent() {
    }

    public ServiceBindingSpecFluent(ServiceBindingSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBindingSpec instance) {
        ServiceBindingSpec serviceBindingSpec = instance = instance != null ? instance : new ServiceBindingSpec();
        if (instance != null) {
            this.withApplication(instance.getApplication());
            this.withServices(instance.getServices());
            this.withEnvVarPrefix(instance.getEnvVarPrefix());
            this.withDetectBindingResources(instance.getDetectBindingResources());
            this.withBindAsFiles(instance.isBindAsFiles());
            this.withMountPath(instance.getMountPath());
            this.withCustomEnvVar(instance.getCustomEnvVar());
        }
    }

    public Application buildApplication() {
        return this.application != null ? this.application.build() : null;
    }

    public A withApplication(Application application) {
        this._visitables.remove((Object)"application");
        if (application != null) {
            this.application = new ApplicationBuilder(application);
            this._visitables.get((Object)"application").add(this.application);
        } else {
            this.application = null;
            this._visitables.get((Object)"application").remove((Object)this.application);
        }
        return (A)((Object)this);
    }

    public boolean hasApplication() {
        return this.application != null;
    }

    public ApplicationNested<A> withNewApplication() {
        return new ApplicationNested(null);
    }

    public ApplicationNested<A> withNewApplicationLike(Application item) {
        return new ApplicationNested(item);
    }

    public ApplicationNested<A> editApplication() {
        return this.withNewApplicationLike(Optional.ofNullable(this.buildApplication()).orElse(null));
    }

    public ApplicationNested<A> editOrNewApplication() {
        return this.withNewApplicationLike(Optional.ofNullable(this.buildApplication()).orElse(new ApplicationBuilder().build()));
    }

    public ApplicationNested<A> editOrNewApplicationLike(Application item) {
        return this.withNewApplicationLike(Optional.ofNullable(this.buildApplication()).orElse(item));
    }

    public A withServices(Service ... services) {
        if (this.services != null) {
            this.services.clear();
            this._visitables.remove((Object)"services");
        }
        if (services != null) {
            for (Service item : services) {
                this.addToServices(item);
            }
        }
        return (A)((Object)this);
    }

    public Service[] buildServices() {
        int size = this.services != null ? this.services.size() : 0;
        Service[] result = new Service[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (Service)visitableBuilder.build();
        }
        return result;
    }

    public Service buildService(int index) {
        return this.services.get(index).build();
    }

    public Service buildFirstService() {
        return this.services.get(0).build();
    }

    public Service buildLastService() {
        return this.services.get(this.services.size() - 1).build();
    }

    public Service buildMatchingService(Predicate<ServiceBuilder> predicate) {
        for (ServiceBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingService(Predicate<ServiceBuilder> predicate) {
        for (ServiceBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToServices(int index, Service item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceBuilder builder = new ServiceBuilder(item);
        if (index < 0 || index >= this.services.size()) {
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        } else {
            this._visitables.get((Object)"services").add(index, builder);
            this.services.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToServices(int index, Service item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceBuilder builder = new ServiceBuilder(item);
        if (index < 0 || index >= this.services.size()) {
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        } else {
            this._visitables.get((Object)"services").set(index, builder);
            this.services.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToServices(Service ... items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServices(Collection<Service> items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromServices(Service ... items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").remove((Object)builder);
            this.services.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServices(Collection<Service> items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (Service item : items) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.get((Object)"services").remove((Object)builder);
            this.services.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServices(Predicate<ServiceBuilder> predicate) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceBuilder> each = this.services.iterator();
        List visitables = this._visitables.get((Object)"services");
        while (each.hasNext()) {
            ServiceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    public ServicesNested<A> addNewService() {
        return new ServicesNested(-1, null);
    }

    public ServicesNested<A> addNewServiceLike(Service item) {
        return new ServicesNested(-1, item);
    }

    public ServicesNested<A> setNewServiceLike(int index, Service item) {
        return new ServicesNested(index, item);
    }

    public ServicesNested<A> editService(int index) {
        if (this.services.size() <= index) {
            throw new RuntimeException("Can't edit services. Index exceeds size.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    public ServicesNested<A> editFirstService() {
        if (this.services.size() == 0) {
            throw new RuntimeException("Can't edit first services. The list is empty.");
        }
        return this.setNewServiceLike(0, this.buildService(0));
    }

    public ServicesNested<A> editLastService() {
        int index = this.services.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last services. The list is empty.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    public ServicesNested<A> editMatchingService(Predicate<ServiceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.services.size(); ++i) {
            if (!predicate.test(this.services.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching services. No match found.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    public String getEnvVarPrefix() {
        return this.envVarPrefix;
    }

    public A withEnvVarPrefix(String envVarPrefix) {
        this.envVarPrefix = envVarPrefix;
        return (A)((Object)this);
    }

    public boolean hasEnvVarPrefix() {
        return this.envVarPrefix != null;
    }

    public boolean isDetectBindingResources() {
        return this.detectBindingResources;
    }

    public A withDetectBindingResources(boolean detectBindingResources) {
        this.detectBindingResources = detectBindingResources;
        return (A)((Object)this);
    }

    public boolean hasDetectBindingResources() {
        return true;
    }

    public boolean isBindAsFiles() {
        return this.bindAsFiles;
    }

    public A withBindAsFiles(boolean bindAsFiles) {
        this.bindAsFiles = bindAsFiles;
        return (A)((Object)this);
    }

    public boolean hasBindAsFiles() {
        return true;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)((Object)this);
    }

    public boolean hasMountPath() {
        return this.mountPath != null;
    }

    public A withCustomEnvVar(CustomEnvVar ... customEnvVar) {
        if (this.customEnvVar != null) {
            this.customEnvVar.clear();
            this._visitables.remove((Object)"customEnvVar");
        }
        if (customEnvVar != null) {
            for (CustomEnvVar item : customEnvVar) {
                this.addToCustomEnvVar(item);
            }
        }
        return (A)((Object)this);
    }

    public CustomEnvVar[] buildCustomEnvVar() {
        int size = this.customEnvVar != null ? this.customEnvVar.size() : 0;
        CustomEnvVar[] result = new CustomEnvVar[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.customEnvVar) {
            result[index++] = (CustomEnvVar)visitableBuilder.build();
        }
        return result;
    }

    public CustomEnvVar buildCustomEnvVar(int index) {
        return this.customEnvVar.get(index).build();
    }

    public CustomEnvVar buildFirstCustomEnvVar() {
        return this.customEnvVar.get(0).build();
    }

    public CustomEnvVar buildLastCustomEnvVar() {
        return this.customEnvVar.get(this.customEnvVar.size() - 1).build();
    }

    public CustomEnvVar buildMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        for (CustomEnvVarBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        for (CustomEnvVarBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToCustomEnvVar(int index, CustomEnvVar item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
        if (index < 0 || index >= this.customEnvVar.size()) {
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        } else {
            this._visitables.get((Object)"customEnvVar").add(index, builder);
            this.customEnvVar.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCustomEnvVar(int index, CustomEnvVar item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
        if (index < 0 || index >= this.customEnvVar.size()) {
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        } else {
            this._visitables.get((Object)"customEnvVar").set(index, builder);
            this.customEnvVar.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCustomEnvVar(CustomEnvVar ... items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCustomEnvVar(Collection<CustomEnvVar> items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCustomEnvVar(CustomEnvVar ... items) {
        if (this.customEnvVar == null) {
            return (A)((Object)this);
        }
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove((Object)builder);
            this.customEnvVar.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCustomEnvVar(Collection<CustomEnvVar> items) {
        if (this.customEnvVar == null) {
            return (A)((Object)this);
        }
        for (CustomEnvVar item : items) {
            CustomEnvVarBuilder builder = new CustomEnvVarBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove((Object)builder);
            this.customEnvVar.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        if (this.customEnvVar == null) {
            return (A)((Object)this);
        }
        Iterator<CustomEnvVarBuilder> each = this.customEnvVar.iterator();
        List visitables = this._visitables.get((Object)"customEnvVar");
        while (each.hasNext()) {
            CustomEnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasCustomEnvVar() {
        return this.customEnvVar != null && !this.customEnvVar.isEmpty();
    }

    public CustomEnvVarNested<A> addNewCustomEnvVar() {
        return new CustomEnvVarNested(-1, null);
    }

    public CustomEnvVarNested<A> addNewCustomEnvVarLike(CustomEnvVar item) {
        return new CustomEnvVarNested(-1, item);
    }

    public CustomEnvVarNested<A> setNewCustomEnvVarLike(int index, CustomEnvVar item) {
        return new CustomEnvVarNested(index, item);
    }

    public CustomEnvVarNested<A> editCustomEnvVar(int index) {
        if (this.customEnvVar.size() <= index) {
            throw new RuntimeException("Can't edit customEnvVar. Index exceeds size.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public CustomEnvVarNested<A> editFirstCustomEnvVar() {
        if (this.customEnvVar.size() == 0) {
            throw new RuntimeException("Can't edit first customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(0, this.buildCustomEnvVar(0));
    }

    public CustomEnvVarNested<A> editLastCustomEnvVar() {
        int index = this.customEnvVar.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public CustomEnvVarNested<A> editMatchingCustomEnvVar(Predicate<CustomEnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customEnvVar.size(); ++i) {
            if (!predicate.test(this.customEnvVar.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customEnvVar. No match found.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingSpecFluent that = (ServiceBindingSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.application, (Object)that.application)) {
            return false;
        }
        if (!Objects.equals(this.services, that.services)) {
            return false;
        }
        if (!Objects.equals(this.envVarPrefix, that.envVarPrefix)) {
            return false;
        }
        if (this.detectBindingResources != that.detectBindingResources) {
            return false;
        }
        if (this.bindAsFiles != that.bindAsFiles) {
            return false;
        }
        if (!Objects.equals(this.mountPath, that.mountPath)) {
            return false;
        }
        return Objects.equals(this.customEnvVar, that.customEnvVar);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.application, this.services, this.envVarPrefix, this.detectBindingResources, this.bindAsFiles, this.mountPath, this.customEnvVar, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.application != null) {
            sb.append("application:");
            sb.append((Object)((Object)this.application) + ",");
        }
        if (this.services != null && !this.services.isEmpty()) {
            sb.append("services:");
            sb.append(this.services + ",");
        }
        if (this.envVarPrefix != null) {
            sb.append("envVarPrefix:");
            sb.append(this.envVarPrefix + ",");
        }
        sb.append("detectBindingResources:");
        sb.append(this.detectBindingResources + ",");
        sb.append("bindAsFiles:");
        sb.append(this.bindAsFiles + ",");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.customEnvVar != null && !this.customEnvVar.isEmpty()) {
            sb.append("customEnvVar:");
            sb.append(this.customEnvVar);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDetectBindingResources() {
        return this.withDetectBindingResources(true);
    }

    public A withBindAsFiles() {
        return this.withBindAsFiles(true);
    }

    public class CustomEnvVarNested<N>
    extends CustomEnvVarFluent<CustomEnvVarNested<N>>
    implements Nested<N> {
        CustomEnvVarBuilder builder;
        int index;

        CustomEnvVarNested(int index, CustomEnvVar item) {
            this.index = index;
            this.builder = new CustomEnvVarBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.setToCustomEnvVar(this.index, this.builder.build());
        }

        public N endCustomEnvVar() {
            return this.and();
        }
    }

    public class ServicesNested<N>
    extends ServiceFluent<ServicesNested<N>>
    implements Nested<N> {
        ServiceBuilder builder;
        int index;

        ServicesNested(int index, Service item) {
            this.index = index;
            this.builder = new ServiceBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.setToServices(this.index, this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }

    public class ApplicationNested<N>
    extends ApplicationFluent<ApplicationNested<N>>
    implements Nested<N> {
        ApplicationBuilder builder;

        ApplicationNested(Application item) {
            this.builder = new ApplicationBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingSpecFluent.this.withApplication(this.builder.build());
        }

        public N endApplication() {
            return this.and();
        }
    }
}

