/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.model;

import io.dekorate.servicebinding.model.Application;
import io.dekorate.servicebinding.model.BindingPath;
import io.dekorate.servicebinding.model.BindingPathBuilder;
import io.dekorate.servicebinding.model.BindingPathFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class ApplicationFluent<A extends ApplicationFluent<A>>
extends BaseFluent<A> {
    private String resource;
    private String kind;
    private String group;
    private String version;
    private String name;
    private BindingPathBuilder bindingPath;

    public ApplicationFluent() {
    }

    public ApplicationFluent(Application instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Application instance) {
        Application application = instance = instance != null ? instance : new Application();
        if (instance != null) {
            this.withResource(instance.getResource());
            this.withKind(instance.getKind());
            this.withGroup(instance.getGroup());
            this.withVersion(instance.getVersion());
            this.withName(instance.getName());
            this.withBindingPath(instance.getBindingPath());
        }
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)((Object)this);
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)((Object)this);
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public BindingPath buildBindingPath() {
        return this.bindingPath != null ? this.bindingPath.build() : null;
    }

    public A withBindingPath(BindingPath bindingPath) {
        this._visitables.remove((Object)"bindingPath");
        if (bindingPath != null) {
            this.bindingPath = new BindingPathBuilder(bindingPath);
            this._visitables.get((Object)"bindingPath").add(this.bindingPath);
        } else {
            this.bindingPath = null;
            this._visitables.get((Object)"bindingPath").remove((Object)this.bindingPath);
        }
        return (A)((Object)this);
    }

    public boolean hasBindingPath() {
        return this.bindingPath != null;
    }

    public A withNewBindingPath(String containerPath, String secretPath) {
        return this.withBindingPath(new BindingPath(containerPath, secretPath));
    }

    public BindingPathNested<A> withNewBindingPath() {
        return new BindingPathNested(null);
    }

    public BindingPathNested<A> withNewBindingPathLike(BindingPath item) {
        return new BindingPathNested(item);
    }

    public BindingPathNested<A> editBindingPath() {
        return this.withNewBindingPathLike(Optional.ofNullable(this.buildBindingPath()).orElse(null));
    }

    public BindingPathNested<A> editOrNewBindingPath() {
        return this.withNewBindingPathLike(Optional.ofNullable(this.buildBindingPath()).orElse(new BindingPathBuilder().build()));
    }

    public BindingPathNested<A> editOrNewBindingPathLike(BindingPath item) {
        return this.withNewBindingPathLike(Optional.ofNullable(this.buildBindingPath()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationFluent that = (ApplicationFluent)((Object)o);
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals((Object)this.bindingPath, (Object)that.bindingPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resource, this.kind, this.group, this.version, this.name, this.bindingPath, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.bindingPath != null) {
            sb.append("bindingPath:");
            sb.append((Object)this.bindingPath);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BindingPathNested<N>
    extends BindingPathFluent<BindingPathNested<N>>
    implements Nested<N> {
        BindingPathBuilder builder;

        BindingPathNested(BindingPath item) {
            this.builder = new BindingPathBuilder(this, item);
        }

        public N and() {
            return (N)ApplicationFluent.this.withBindingPath(this.builder.build());
        }

        public N endBindingPath() {
            return this.and();
        }
    }
}

