/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicebinding.config;

import io.dekorate.kubernetes.config.ApplicationConfigurationFluent;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.servicebinding.config.ApplicationConfig;
import io.dekorate.servicebinding.config.ApplicationConfigBuilder;
import io.dekorate.servicebinding.config.ApplicationConfigFluent;
import io.dekorate.servicebinding.config.BindingPathConfig;
import io.dekorate.servicebinding.config.BindingPathConfigBuilder;
import io.dekorate.servicebinding.config.BindingPathConfigFluent;
import io.dekorate.servicebinding.config.ServiceBindingConfig;
import io.dekorate.servicebinding.config.ServiceConfig;
import io.dekorate.servicebinding.config.ServiceConfigBuilder;
import io.dekorate.servicebinding.config.ServiceConfigFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceBindingConfigFluent<A extends ServiceBindingConfigFluent<A>>
extends ApplicationConfigurationFluent<A> {
    private ApplicationConfigBuilder application;
    private ArrayList<ServiceConfigBuilder> services = new ArrayList();
    private String envVarPrefix;
    private Boolean detectBindingResources;
    private Boolean bindAsFiles;
    private String mountPath;
    private ArrayList<EnvBuilder> customEnvVar = new ArrayList();
    private BindingPathConfigBuilder bindingPath;

    public ServiceBindingConfigFluent() {
    }

    public ServiceBindingConfigFluent(ServiceBindingConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBindingConfig instance) {
        ServiceBindingConfig serviceBindingConfig = instance = instance != null ? instance : new ServiceBindingConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withPartOf(instance.getPartOf());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withApplication(instance.getApplication());
            this.withServices(instance.getServices());
            this.withEnvVarPrefix(instance.getEnvVarPrefix());
            this.withDetectBindingResources(instance.getDetectBindingResources());
            this.withBindAsFiles(instance.getBindAsFiles());
            this.withMountPath(instance.getMountPath());
            this.withCustomEnvVar(instance.getCustomEnvVar());
            this.withBindingPath(instance.getBindingPath());
        }
    }

    public ApplicationConfig buildApplication() {
        return this.application != null ? this.application.build() : null;
    }

    public A withApplication(ApplicationConfig application) {
        this._visitables.remove((Object)"application");
        if (application != null) {
            this.application = new ApplicationConfigBuilder(application);
            this._visitables.get((Object)"application").add(this.application);
        } else {
            this.application = null;
            this._visitables.get((Object)"application").remove((Object)this.application);
        }
        return (A)((Object)this);
    }

    public boolean hasApplication() {
        return this.application != null;
    }

    public ApplicationNested<A> withNewApplication() {
        return new ApplicationNested(null);
    }

    public ApplicationNested<A> withNewApplicationLike(ApplicationConfig item) {
        return new ApplicationNested(item);
    }

    public ApplicationNested<A> editApplication() {
        return this.withNewApplicationLike(Optional.ofNullable(this.buildApplication()).orElse(null));
    }

    public ApplicationNested<A> editOrNewApplication() {
        return this.withNewApplicationLike(Optional.ofNullable(this.buildApplication()).orElse(new ApplicationConfigBuilder().build()));
    }

    public ApplicationNested<A> editOrNewApplicationLike(ApplicationConfig item) {
        return this.withNewApplicationLike(Optional.ofNullable(this.buildApplication()).orElse(item));
    }

    public A withServices(ServiceConfig ... services) {
        if (this.services != null) {
            this.services.clear();
            this._visitables.remove((Object)"services");
        }
        if (services != null) {
            for (ServiceConfig item : services) {
                this.addToServices(item);
            }
        }
        return (A)((Object)this);
    }

    public ServiceConfig[] buildServices() {
        int size = this.services != null ? this.services.size() : 0;
        ServiceConfig[] result = new ServiceConfig[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.services) {
            result[index++] = (ServiceConfig)((Object)visitableBuilder.build());
        }
        return result;
    }

    public ServiceConfig buildService(int index) {
        return this.services.get(index).build();
    }

    public ServiceConfig buildFirstService() {
        return this.services.get(0).build();
    }

    public ServiceConfig buildLastService() {
        return this.services.get(this.services.size() - 1).build();
    }

    public ServiceConfig buildMatchingService(Predicate<ServiceConfigBuilder> predicate) {
        for (ServiceConfigBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingService(Predicate<ServiceConfigBuilder> predicate) {
        for (ServiceConfigBuilder item : this.services) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToServices(int index, ServiceConfig item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
        if (index < 0 || index >= this.services.size()) {
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        } else {
            this._visitables.get((Object)"services").add(index, builder);
            this.services.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToServices(int index, ServiceConfig item) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
        if (index < 0 || index >= this.services.size()) {
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        } else {
            this._visitables.get((Object)"services").set(index, builder);
            this.services.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToServices(ServiceConfig ... items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServices(Collection<ServiceConfig> items) {
        if (this.services == null) {
            this.services = new ArrayList();
        }
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").add(builder);
            this.services.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromServices(ServiceConfig ... items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").remove((Object)builder);
            this.services.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServices(Collection<ServiceConfig> items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (ServiceConfig item : items) {
            ServiceConfigBuilder builder = new ServiceConfigBuilder(item);
            this._visitables.get((Object)"services").remove((Object)builder);
            this.services.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServices(Predicate<ServiceConfigBuilder> predicate) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        Iterator<ServiceConfigBuilder> each = this.services.iterator();
        List visitables = this._visitables.get((Object)"services");
        while (each.hasNext()) {
            ServiceConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    public ServicesNested<A> addNewService() {
        return new ServicesNested(-1, null);
    }

    public ServicesNested<A> addNewServiceLike(ServiceConfig item) {
        return new ServicesNested(-1, item);
    }

    public ServicesNested<A> setNewServiceLike(int index, ServiceConfig item) {
        return new ServicesNested(index, item);
    }

    public ServicesNested<A> editService(int index) {
        if (this.services.size() <= index) {
            throw new RuntimeException("Can't edit services. Index exceeds size.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    public ServicesNested<A> editFirstService() {
        if (this.services.size() == 0) {
            throw new RuntimeException("Can't edit first services. The list is empty.");
        }
        return this.setNewServiceLike(0, this.buildService(0));
    }

    public ServicesNested<A> editLastService() {
        int index = this.services.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last services. The list is empty.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    public ServicesNested<A> editMatchingService(Predicate<ServiceConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.services.size(); ++i) {
            if (!predicate.test(this.services.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching services. No match found.");
        }
        return this.setNewServiceLike(index, this.buildService(index));
    }

    public String getEnvVarPrefix() {
        return this.envVarPrefix;
    }

    public A withEnvVarPrefix(String envVarPrefix) {
        this.envVarPrefix = envVarPrefix;
        return (A)((Object)this);
    }

    public boolean hasEnvVarPrefix() {
        return this.envVarPrefix != null;
    }

    public Boolean getDetectBindingResources() {
        return this.detectBindingResources;
    }

    public A withDetectBindingResources(Boolean detectBindingResources) {
        this.detectBindingResources = detectBindingResources;
        return (A)((Object)this);
    }

    public boolean hasDetectBindingResources() {
        return this.detectBindingResources != null;
    }

    public Boolean getBindAsFiles() {
        return this.bindAsFiles;
    }

    public A withBindAsFiles(Boolean bindAsFiles) {
        this.bindAsFiles = bindAsFiles;
        return (A)((Object)this);
    }

    public boolean hasBindAsFiles() {
        return this.bindAsFiles != null;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)((Object)this);
    }

    public boolean hasMountPath() {
        return this.mountPath != null;
    }

    public A withCustomEnvVar(Env ... customEnvVar) {
        if (this.customEnvVar != null) {
            this.customEnvVar.clear();
            this._visitables.remove((Object)"customEnvVar");
        }
        if (customEnvVar != null) {
            for (Env item : customEnvVar) {
                this.addToCustomEnvVar(item);
            }
        }
        return (A)((Object)this);
    }

    public Env[] buildCustomEnvVar() {
        int size = this.customEnvVar != null ? this.customEnvVar.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.customEnvVar) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    public Env buildCustomEnvVar(int index) {
        return this.customEnvVar.get(index).build();
    }

    public Env buildFirstCustomEnvVar() {
        return this.customEnvVar.get(0).build();
    }

    public Env buildLastCustomEnvVar() {
        return this.customEnvVar.get(this.customEnvVar.size() - 1).build();
    }

    public Env buildMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.customEnvVar) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToCustomEnvVar(int index, Env item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.customEnvVar.size()) {
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        } else {
            this._visitables.get((Object)"customEnvVar").add(index, builder);
            this.customEnvVar.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCustomEnvVar(int index, Env item) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.customEnvVar.size()) {
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        } else {
            this._visitables.get((Object)"customEnvVar").set(index, builder);
            this.customEnvVar.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCustomEnvVar(Env ... items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCustomEnvVar(Collection<Env> items) {
        if (this.customEnvVar == null) {
            this.customEnvVar = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").add(builder);
            this.customEnvVar.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCustomEnvVar(Env ... items) {
        if (this.customEnvVar == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove(builder);
            this.customEnvVar.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCustomEnvVar(Collection<Env> items) {
        if (this.customEnvVar == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"customEnvVar").remove(builder);
            this.customEnvVar.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCustomEnvVar(Predicate<EnvBuilder> predicate) {
        if (this.customEnvVar == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.customEnvVar.iterator();
        List visitables = this._visitables.get((Object)"customEnvVar");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasCustomEnvVar() {
        return this.customEnvVar != null && !this.customEnvVar.isEmpty();
    }

    public CustomEnvVarNested<A> addNewCustomEnvVar() {
        return new CustomEnvVarNested(-1, null);
    }

    public CustomEnvVarNested<A> addNewCustomEnvVarLike(Env item) {
        return new CustomEnvVarNested(-1, item);
    }

    public CustomEnvVarNested<A> setNewCustomEnvVarLike(int index, Env item) {
        return new CustomEnvVarNested(index, item);
    }

    public CustomEnvVarNested<A> editCustomEnvVar(int index) {
        if (this.customEnvVar.size() <= index) {
            throw new RuntimeException("Can't edit customEnvVar. Index exceeds size.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public CustomEnvVarNested<A> editFirstCustomEnvVar() {
        if (this.customEnvVar.size() == 0) {
            throw new RuntimeException("Can't edit first customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(0, this.buildCustomEnvVar(0));
    }

    public CustomEnvVarNested<A> editLastCustomEnvVar() {
        int index = this.customEnvVar.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last customEnvVar. The list is empty.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public CustomEnvVarNested<A> editMatchingCustomEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.customEnvVar.size(); ++i) {
            if (!predicate.test(this.customEnvVar.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching customEnvVar. No match found.");
        }
        return this.setNewCustomEnvVarLike(index, this.buildCustomEnvVar(index));
    }

    public BindingPathConfig buildBindingPath() {
        return this.bindingPath != null ? this.bindingPath.build() : null;
    }

    public A withBindingPath(BindingPathConfig bindingPath) {
        this._visitables.remove((Object)"bindingPath");
        if (bindingPath != null) {
            this.bindingPath = new BindingPathConfigBuilder(bindingPath);
            this._visitables.get((Object)"bindingPath").add(this.bindingPath);
        } else {
            this.bindingPath = null;
            this._visitables.get((Object)"bindingPath").remove((Object)this.bindingPath);
        }
        return (A)((Object)this);
    }

    public boolean hasBindingPath() {
        return this.bindingPath != null;
    }

    public BindingPathNested<A> withNewBindingPath() {
        return new BindingPathNested(null);
    }

    public BindingPathNested<A> withNewBindingPathLike(BindingPathConfig item) {
        return new BindingPathNested(item);
    }

    public BindingPathNested<A> editBindingPath() {
        return this.withNewBindingPathLike(Optional.ofNullable(this.buildBindingPath()).orElse(null));
    }

    public BindingPathNested<A> editOrNewBindingPath() {
        return this.withNewBindingPathLike(Optional.ofNullable(this.buildBindingPath()).orElse(new BindingPathConfigBuilder().build()));
    }

    public BindingPathNested<A> editOrNewBindingPathLike(BindingPathConfig item) {
        return this.withNewBindingPathLike(Optional.ofNullable(this.buildBindingPath()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingConfigFluent that = (ServiceBindingConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.application, (Object)that.application)) {
            return false;
        }
        if (!Objects.equals(this.services, that.services)) {
            return false;
        }
        if (!Objects.equals(this.envVarPrefix, that.envVarPrefix)) {
            return false;
        }
        if (!Objects.equals(this.detectBindingResources, that.detectBindingResources)) {
            return false;
        }
        if (!Objects.equals(this.bindAsFiles, that.bindAsFiles)) {
            return false;
        }
        if (!Objects.equals(this.mountPath, that.mountPath)) {
            return false;
        }
        if (!Objects.equals(this.customEnvVar, that.customEnvVar)) {
            return false;
        }
        return Objects.equals((Object)this.bindingPath, (Object)that.bindingPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.application, this.services, this.envVarPrefix, this.detectBindingResources, this.bindAsFiles, this.mountPath, this.customEnvVar, this.bindingPath, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.application != null) {
            sb.append("application:");
            sb.append((Object)((Object)this.application) + ",");
        }
        if (this.services != null && !this.services.isEmpty()) {
            sb.append("services:");
            sb.append(this.services + ",");
        }
        if (this.envVarPrefix != null) {
            sb.append("envVarPrefix:");
            sb.append(this.envVarPrefix + ",");
        }
        if (this.detectBindingResources != null) {
            sb.append("detectBindingResources:");
            sb.append(this.detectBindingResources + ",");
        }
        if (this.bindAsFiles != null) {
            sb.append("bindAsFiles:");
            sb.append(this.bindAsFiles + ",");
        }
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.customEnvVar != null && !this.customEnvVar.isEmpty()) {
            sb.append("customEnvVar:");
            sb.append(this.customEnvVar + ",");
        }
        if (this.bindingPath != null) {
            sb.append("bindingPath:");
            sb.append((Object)this.bindingPath);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDetectBindingResources() {
        return this.withDetectBindingResources(true);
    }

    public A withBindAsFiles() {
        return this.withBindAsFiles(true);
    }

    public class BindingPathNested<N>
    extends BindingPathConfigFluent<BindingPathNested<N>>
    implements Nested<N> {
        BindingPathConfigBuilder builder;

        BindingPathNested(BindingPathConfig item) {
            this.builder = new BindingPathConfigBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingConfigFluent.this.withBindingPath(this.builder.build());
        }

        public N endBindingPath() {
            return this.and();
        }
    }

    public class CustomEnvVarNested<N>
    extends EnvFluent<CustomEnvVarNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        CustomEnvVarNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder((EnvFluent)this, item);
        }

        public N and() {
            return (N)ServiceBindingConfigFluent.this.setToCustomEnvVar(this.index, (Env)this.builder.build());
        }

        public N endCustomEnvVar() {
            return this.and();
        }
    }

    public class ServicesNested<N>
    extends ServiceConfigFluent<ServicesNested<N>>
    implements Nested<N> {
        ServiceConfigBuilder builder;
        int index;

        ServicesNested(int index, ServiceConfig item) {
            this.index = index;
            this.builder = new ServiceConfigBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingConfigFluent.this.setToServices(this.index, this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }

    public class ApplicationNested<N>
    extends ApplicationConfigFluent<ApplicationNested<N>>
    implements Nested<N> {
        ApplicationConfigBuilder builder;

        ApplicationNested(ApplicationConfig item) {
            this.builder = new ApplicationConfigBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingConfigFluent.this.withApplication(this.builder.build());
        }

        public N endApplication() {
            return this.and();
        }
    }
}

