/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.AccessMode;
import io.dekorate.kubernetes.config.ApplicationConfigurationFluentImpl;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.LabelFluentImpl;
import io.dekorate.kubernetes.config.PersistentVolumeClaimConfig;
import io.dekorate.kubernetes.config.PersistentVolumeClaimConfigFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PersistentVolumeClaimConfigFluentImpl<A extends PersistentVolumeClaimConfigFluent<A>>
extends ApplicationConfigurationFluentImpl<A>
implements PersistentVolumeClaimConfigFluent<A> {
    private int size;
    private String unit;
    private String storageClass;
    private AccessMode accessMode;
    private ArrayList<LabelBuilder> matchLabels = new ArrayList();

    public PersistentVolumeClaimConfigFluentImpl() {
    }

    public PersistentVolumeClaimConfigFluentImpl(PersistentVolumeClaimConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPartOf(instance.getPartOf());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withSize(instance.getSize());
        this.withUnit(instance.getUnit());
        this.withStorageClass(instance.getStorageClass());
        this.withAccessMode(instance.getAccessMode());
        this.withMatchLabels(instance.getMatchLabels());
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public A withSize(int size) {
        this.size = size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return true;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public A withUnit(String unit) {
        this.unit = unit;
        return (A)this;
    }

    @Override
    public Boolean hasUnit() {
        return this.unit != null;
    }

    @Override
    public String getStorageClass() {
        return this.storageClass;
    }

    @Override
    public A withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return (A)this;
    }

    @Override
    public Boolean hasStorageClass() {
        return this.storageClass != null;
    }

    @Override
    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public A withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return (A)this;
    }

    @Override
    public Boolean hasAccessMode() {
        return this.accessMode != null;
    }

    @Override
    public A withMatchLabels(Label ... matchLabels) {
        if (this.matchLabels != null) {
            this.matchLabels.clear();
        }
        if (matchLabels != null) {
            for (Label item : matchLabels) {
                this.addToMatchLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Label[] getMatchLabels() {
        int size = this.matchLabels != null ? this.matchLabels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.matchLabels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Label[] buildMatchLabels() {
        int size = this.matchLabels != null ? this.matchLabels.size() : 0;
        Label[] result = new Label[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.matchLabels) {
            result[index++] = (Label)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Label buildMatchLabel(Integer index) {
        return this.matchLabels.get(index).build();
    }

    @Override
    public Label buildFirstMatchLabel() {
        return this.matchLabels.get(0).build();
    }

    @Override
    public Label buildLastMatchLabel() {
        return this.matchLabels.get(this.matchLabels.size() - 1).build();
    }

    @Override
    public Label buildMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.matchLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
        for (LabelBuilder item : this.matchLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToMatchLabels(Integer index, Label item) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        this._visitables.get((Object)"matchLabels").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"matchLabels").size(), builder);
        this.matchLabels.add(index >= 0 ? index.intValue() : this.matchLabels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatchLabels(Integer index, Label item) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        LabelBuilder builder = new LabelBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"matchLabels").size()) {
            this._visitables.get((Object)"matchLabels").add(builder);
        } else {
            this._visitables.get((Object)"matchLabels").set(index, builder);
        }
        if (index < 0 || index >= this.matchLabels.size()) {
            this.matchLabels.add(builder);
        } else {
            this.matchLabels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatchLabels(Label ... items) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").add(builder);
            this.matchLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchLabels(Collection<Label> items) {
        if (this.matchLabels == null) {
            this.matchLabels = new ArrayList();
        }
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").add(builder);
            this.matchLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(Label ... items) {
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").remove(builder);
            if (this.matchLabels == null) continue;
            this.matchLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchLabels(Collection<Label> items) {
        for (Label item : items) {
            LabelBuilder builder = new LabelBuilder(item);
            this._visitables.get((Object)"matchLabels").remove(builder);
            if (this.matchLabels == null) continue;
            this.matchLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMatchLabels(Predicate<LabelBuilder> predicate) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        Iterator<LabelBuilder> each = this.matchLabels.iterator();
        List visitables = this._visitables.get((Object)"matchLabels");
        while (each.hasNext()) {
            LabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchLabels() {
        return this.matchLabels != null && !this.matchLabels.isEmpty();
    }

    @Override
    public A addNewMatchLabel(String key, String value, String[] kinds) {
        return this.addToMatchLabels(new Label(key, value, kinds));
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> addNewMatchLabel() {
        return new MatchLabelsNestedImpl();
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> addNewMatchLabelLike(Label item) {
        return new MatchLabelsNestedImpl(-1, item);
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> setNewMatchLabelLike(Integer index, Label item) {
        return new MatchLabelsNestedImpl(index, item);
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> editMatchLabel(Integer index) {
        if (this.matchLabels.size() <= index) {
            throw new RuntimeException("Can't edit matchLabels. Index exceeds size.");
        }
        return this.setNewMatchLabelLike(index, this.buildMatchLabel(index));
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> editFirstMatchLabel() {
        if (this.matchLabels.size() == 0) {
            throw new RuntimeException("Can't edit first matchLabels. The list is empty.");
        }
        return this.setNewMatchLabelLike(0, this.buildMatchLabel(0));
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> editLastMatchLabel() {
        int index = this.matchLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchLabels. The list is empty.");
        }
        return this.setNewMatchLabelLike(index, this.buildMatchLabel(index));
    }

    @Override
    public PersistentVolumeClaimConfigFluent.MatchLabelsNested<A> editMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchLabels.size(); ++i) {
            if (!predicate.test(this.matchLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchLabels. No match found.");
        }
        return this.setNewMatchLabelLike(index, this.buildMatchLabel(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeClaimConfigFluentImpl that = (PersistentVolumeClaimConfigFluentImpl)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) {
            return false;
        }
        if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) {
            return false;
        }
        if (this.accessMode != null ? !this.accessMode.equals((Object)that.accessMode) : that.accessMode != null) {
            return false;
        }
        return !(this.matchLabels != null ? !this.matchLabels.equals(that.matchLabels) : that.matchLabels != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.unit, this.storageClass, this.accessMode, this.matchLabels, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("size:");
        sb.append(this.size + ",");
        if (this.unit != null) {
            sb.append("unit:");
            sb.append(this.unit + ",");
        }
        if (this.storageClass != null) {
            sb.append("storageClass:");
            sb.append(this.storageClass + ",");
        }
        if (this.accessMode != null) {
            sb.append("accessMode:");
            sb.append((Object)((Object)this.accessMode) + ",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    class MatchLabelsNestedImpl<N>
    extends LabelFluentImpl<PersistentVolumeClaimConfigFluent.MatchLabelsNested<N>>
    implements PersistentVolumeClaimConfigFluent.MatchLabelsNested<N>,
    Nested<N> {
        LabelBuilder builder;
        Integer index;

        MatchLabelsNestedImpl(Integer index, Label item) {
            this.index = index;
            this.builder = new LabelBuilder(this, item);
        }

        MatchLabelsNestedImpl() {
            this.index = -1;
            this.builder = new LabelBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimConfigFluentImpl.this.setToMatchLabels(this.index, this.builder.build());
        }

        @Override
        public N endMatchLabel() {
            return this.and();
        }
    }
}

