/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.source.DataSourceWrapper;
import com.otaliastudios.transcoder.source.TrimDataSource;

public class ClipDataSource
extends DataSourceWrapper {
    public ClipDataSource(@NonNull DataSource source, long clipStartUs) {
        super(new TrimDataSource(source, clipStartUs));
    }

    public ClipDataSource(@NonNull DataSource source, long clipStartUs, long clipEndUs) {
        super(new TrimDataSource(source, clipStartUs, ClipDataSource.getSourceDurationUs(source) - clipEndUs));
    }

    private static long getSourceDurationUs(@NonNull DataSource source) {
        if (!source.isInitialized()) {
            source.initialize();
        }
        return source.getDurationUs();
    }
}

