/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.pipeline;

import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.pipeline.Step;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013J\b\u0010'\u001a\u0004\u0018\u00010(R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/otaliastudios/transcoder/internal/pipeline/PipelineItem;", "", "step", "Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "Lcom/otaliastudios/transcoder/internal/pipeline/Channel;", "name", "", "<init>", "(Lcom/otaliastudios/transcoder/internal/pipeline/Step;Ljava/lang/String;)V", "getStep", "()Lcom/otaliastudios/transcoder/internal/pipeline/Step;", "getName", "()Ljava/lang/String;", "unhandled", "Lkotlin/collections/ArrayDeque;", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "getUnhandled", "()Lkotlin/collections/ArrayDeque;", "done", "", "getDone", "()Z", "setDone", "(Z)V", "advanced", "getAdvanced", "setAdvanced", "packets", "", "getPackets", "()I", "setPackets", "(I)V", "nextUnhandled", "attachToNext", "", "next", "canHandle", "first", "handle", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Failure;", "lib_release"})
final class PipelineItem {
    @NotNull
    private final Step<Object, Channel, Object, Channel> step;
    @NotNull
    private final String name;
    @NotNull
    private final ArrayDeque<State.Ok<Object>> unhandled;
    private boolean done;
    private boolean advanced;
    private int packets;
    @Nullable
    private ArrayDeque<State.Ok<Object>> nextUnhandled;

    public PipelineItem(@NotNull Step<Object, Channel, Object, Channel> step, @NotNull String name) {
        Intrinsics.checkNotNullParameter(step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.step = step;
        this.name = name;
        this.unhandled = new ArrayDeque();
    }

    @NotNull
    public final Step<Object, Channel, Object, Channel> getStep() {
        return this.step;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ArrayDeque<State.Ok<Object>> getUnhandled() {
        return this.unhandled;
    }

    public final boolean getDone() {
        return this.done;
    }

    public final void setDone(boolean bl) {
        this.done = bl;
    }

    public final boolean getAdvanced() {
        return this.advanced;
    }

    public final void setAdvanced(boolean bl) {
        this.advanced = bl;
    }

    public final int getPackets() {
        return this.packets;
    }

    public final void setPackets(int n) {
        this.packets = n;
    }

    public final void attachToNext(@NotNull PipelineItem next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        this.nextUnhandled = next.unhandled;
        this.step.initialize(next.step.getChannel());
    }

    public final boolean canHandle(boolean first) {
        if (this.done) {
            return false;
        }
        if (first) {
            this.unhandled.clear();
            this.unhandled.addLast(new State.Ok<Unit>(Unit.INSTANCE));
        }
        return !((Collection)this.unhandled).isEmpty() || this.step instanceof QueuedStep;
    }

    @Nullable
    public final State.Failure handle() {
        this.advanced = false;
        while (!((Collection)this.unhandled).isEmpty() && !this.done) {
            State.Ok input = (State.Ok)this.unhandled.removeFirst();
            State<Object> result = this.step.advance(input);
            if (result instanceof State.Ok) {
                int n = this.packets;
                this.packets = n + 1;
                this.advanced = true;
                this.done = result instanceof State.Eos;
                ArrayDeque<State.Ok<Object>> arrayDeque = this.nextUnhandled;
                if (arrayDeque != null) {
                    arrayDeque.addLast(result);
                }
                continue;
            }
            if (result instanceof State.Retry) {
                this.unhandled.addFirst((Object)input);
                return (State.Failure)result;
            }
            if (result instanceof State.Consume) {
                return (State.Failure)result;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!this.advanced && !this.done && this.step instanceof QueuedStep) {
            State result = ((QueuedStep)this.step).tryAdvance();
            if (result instanceof State.Ok) {
                int n = this.packets;
                this.packets = n + 1;
                this.advanced = true;
                this.done = result instanceof State.Eos;
                ArrayDeque<State.Ok<Object>> arrayDeque = this.nextUnhandled;
                if (arrayDeque != null) {
                    arrayDeque.addLast(result);
                }
            } else {
                if (result instanceof State.Failure) {
                    return (State.Failure)result;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }
}

