/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.data;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.internal.data.ReaderChannel;
import com.otaliastudios.transcoder.internal.data.ReaderData;
import com.otaliastudios.transcoder.internal.data.WriterChannel;
import com.otaliastudios.transcoder.internal.data.WriterData;
import com.otaliastudios.transcoder.internal.pipeline.BaseStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.source.DataSource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/otaliastudios/transcoder/internal/data/Bridge;", "Lcom/otaliastudios/transcoder/internal/pipeline/BaseStep;", "Lcom/otaliastudios/transcoder/internal/data/ReaderData;", "Lcom/otaliastudios/transcoder/internal/data/ReaderChannel;", "Lcom/otaliastudios/transcoder/internal/data/WriterData;", "Lcom/otaliastudios/transcoder/internal/data/WriterChannel;", "format", "Landroid/media/MediaFormat;", "<init>", "(Landroid/media/MediaFormat;)V", "bufferSize", "", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "Ljava/nio/ByteBuffer;", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/data/Bridge;", "Lkotlin/Pair;", "initialize", "", "next", "advance", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "lib_release"})
public final class Bridge
extends BaseStep<ReaderData, ReaderChannel, WriterData, WriterChannel>
implements ReaderChannel {
    @NotNull
    private final MediaFormat format;
    private final int bufferSize;
    private final ByteBuffer buffer;
    @NotNull
    private final Bridge channel;

    public Bridge(@NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        super("Bridge");
        this.format = format;
        this.bufferSize = this.format.getInteger("max-input-size");
        this.buffer = ByteBuffer.allocateDirect(this.bufferSize).order(ByteOrder.nativeOrder());
        this.channel = this;
    }

    @Override
    @NotNull
    public Bridge getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public Pair<ByteBuffer, Integer> buffer() {
        this.buffer.clear();
        return TuplesKt.to((Object)this.buffer, (Object)0);
    }

    @Override
    public void initialize(@NotNull WriterChannel next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        this.getLog().i("initialize(): format=" + this.format);
        next.handleFormat(this.format);
    }

    @Override
    @NotNull
    public State<WriterData> advance(@NotNull State.Ok<ReaderData> state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        DataSource.Chunk chunk = state.getValue().component1();
        int flags = chunk.keyframe ? 1 : 0;
        ByteBuffer byteBuffer = chunk.buffer;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
        WriterData result = new WriterData(byteBuffer, chunk.timeUs, flags, (Function0<Unit>)((Function0)Bridge::advance$lambda$0));
        return state instanceof State.Eos ? (State)new State.Eos<WriterData>(result) : (State)new State.Ok<WriterData>(result);
    }

    private static final Unit advance$lambda$0() {
        return Unit.INSTANCE;
    }
}

