/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.common.TrackTypeKt;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.codec.DecoderDropper;
import com.otaliastudios.transcoder.internal.data.ReaderChannel;
import com.otaliastudios.transcoder.internal.data.ReaderData;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.source.DataSource;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0016\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0002H\u0014J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0002H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$H\u0014J\b\u0010%\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/Decoder;", "Lcom/otaliastudios/transcoder/internal/pipeline/QueuedStep;", "Lcom/otaliastudios/transcoder/internal/data/ReaderData;", "Lcom/otaliastudios/transcoder/internal/data/ReaderChannel;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "format", "Landroid/media/MediaFormat;", "continuous", "", "<init>", "(Landroid/media/MediaFormat;Z)V", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/codec/Decoder;", "decoder", "Lcom/otaliastudios/transcoder/internal/Codecs$Codec;", "info", "Landroid/media/MediaCodec$BufferInfo;", "dropper", "Lcom/otaliastudios/transcoder/internal/codec/DecoderDropper;", "surfaceRendering", "surfaceRenderingDummyBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "Ljava/nio/ByteBuffer;", "initialize", "", "next", "buffer", "Lkotlin/Pair;", "", "enqueueEos", "data", "enqueue", "drain", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "release", "lib_release"})
public final class Decoder
extends QueuedStep<ReaderData, ReaderChannel, DecoderData, DecoderChannel>
implements ReaderChannel {
    @NotNull
    private final MediaFormat format;
    @NotNull
    private final Decoder channel;
    @NotNull
    private final Codecs.Codec decoder;
    @NotNull
    private MediaCodec.BufferInfo info;
    @NotNull
    private final DecoderDropper dropper;
    private boolean surfaceRendering;
    private final ByteBuffer surfaceRenderingDummyBuffer;

    public Decoder(@NotNull MediaFormat format, boolean continuous) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        super(switch (WhenMappings.$EnumSwitchMapping$0[TrackTypeKt.getTrackType(format).ordinal()]) {
            case 1 -> "VideoDecoder";
            case 2 -> "AudioDecoder";
            default -> throw new NoWhenBranchMatchedException();
        });
        this.format = format;
        this.channel = this;
        this.getLog().i("init: instantiating codec...");
        String string = this.format.getString("mime");
        Intrinsics.checkNotNull((Object)string);
        MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createDecoderByType(...)");
        this.decoder = new Codecs.Codec(mediaCodec, null, this.getLog());
        this.info = new MediaCodec.BufferInfo();
        this.dropper = new DecoderDropper(continuous);
        this.surfaceRenderingDummyBuffer = ByteBuffer.allocateDirect(0);
    }

    @Override
    @NotNull
    public Decoder getChannel() {
        return this.channel;
    }

    @Override
    public void initialize(@NotNull DecoderChannel next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        super.initialize((Channel)next);
        this.getLog().i("initialize()");
        Surface surface = next.handleSourceFormat(this.format);
        this.surfaceRendering = surface != null;
        this.decoder.getCodec().configure(this.format, surface, null, 0);
        this.decoder.getCodec().start();
    }

    @Override
    @Nullable
    public Pair<ByteBuffer, Integer> buffer() {
        return this.decoder.getInputBuffer();
    }

    @Override
    protected void enqueueEos(@NotNull ReaderData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getLog().i("enqueueEos()!");
        Codecs.Codec codec = this.decoder;
        int n = codec.getDequeuedInputs();
        codec.setDequeuedInputs(n + -1);
        this.decoder.getCodec().queueInputBuffer(data.getId(), 0, 0, 0L, 4);
    }

    @Override
    protected void enqueue(@NotNull ReaderData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Codecs.Codec codec = this.decoder;
        int n = codec.getDequeuedInputs();
        codec.setDequeuedInputs(n + -1);
        DataSource.Chunk chunk = data.component1();
        int id = data.component2();
        int flag = chunk.keyframe ? 1 : 0;
        this.getLog().v("enqueued " + chunk.buffer.remaining() + " bytes (" + chunk.timeUs + "us)");
        this.decoder.getCodec().queueInputBuffer(id, chunk.buffer.position(), chunk.buffer.remaining(), chunk.timeUs, flag);
        this.dropper.input(chunk.timeUs, chunk.render);
    }

    @Override
    @NotNull
    protected State<DecoderData> drain() {
        int result = this.decoder.getCodec().dequeueOutputBuffer(this.info, 100L);
        return switch (result) {
            case -1 -> {
                this.getLog().i("drain(): got INFO_TRY_AGAIN_LATER, waiting.");
                yield new State.Retry(true);
            }
            case -2 -> {
                this.getLog().i("drain(): got INFO_OUTPUT_FORMAT_CHANGED, handling format and retrying. format=" + this.decoder.getCodec().getOutputFormat());
                DecoderChannel v1 = (DecoderChannel)this.getNext();
                MediaFormat v2 = this.decoder.getCodec().getOutputFormat();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getOutputFormat(...)");
                v1.handleRawFormat(v2);
                yield this.drain();
            }
            case -3 -> {
                this.getLog().i("drain(): got INFO_OUTPUT_BUFFERS_CHANGED, retrying.");
                yield this.drain();
            }
            default -> {
                State var4_4;
                State v5;
                Long timeUs;
                boolean isEos = (this.info.flags & 4) != 0;
                Long v3 = timeUs = isEos ? Long.valueOf(0L) : this.dropper.output(this.info.presentationTimeUs);
                if (timeUs != null) {
                    ByteBuffer codecBuffer = this.decoder.getCodec().getOutputBuffer(result);
                    ByteBuffer v4 = codecBuffer;
                    if (v4 == null) {
                        if (this.surfaceRendering) {
                            v4 = this.surfaceRenderingDummyBuffer;
                        } else {
                            throw new IllegalStateException(("outputBuffer(" + result + ", " + this.info.size + ", " + this.info.offset + ", " + this.info.flags + ") should not be null.").toString());
                        }
                    }
                    ByteBuffer buffer = v4;
                    Codecs.Codec var6_6 = this.decoder;
                    int var7_8 = var6_6.getDequeuedOutputs();
                    var6_6.setDequeuedOutputs(var7_8 + 1);
                    Intrinsics.checkNotNull((Object)buffer);
                    DecoderData data = new DecoderData(buffer, timeUs, (Function1<? super Boolean, Unit>)((Function1)arg_0 -> Decoder.drain$lambda$0(this, result, arg_0)));
                    v5 = isEos ? (State.Ok)new State.Eos<DecoderData>(data) : new State.Ok(data);
                } else {
                    this.decoder.getCodec().releaseOutputBuffer(result, false);
                    v5 = new State.Retry(false);
                }
                State it = var4_4 = v5;
                boolean $i$a$-also-Decoder$drain$1 = false;
                this.getLog().v("drain(): returning " + it);
                yield var4_4;
            }
        };
    }

    @Override
    public void release() {
        this.getLog().i("release: releasing codec. " + this.decoder.getState());
        this.decoder.getCodec().stop();
        this.decoder.getCodec().release();
    }

    private static final Unit drain$lambda$0(Decoder this$0, int $result, boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.decoder.getCodec().releaseOutputBuffer($result, it);
        Codecs.Codec codec = this$0.decoder;
        int n = codec.getDequeuedOutputs();
        codec.setDequeuedOutputs(n + -1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            try {
                nArray[TrackType.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

