/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.otaliastudios.transcoder.Thumbnailer;
import com.otaliastudios.transcoder.ThumbnailerListener;
import com.otaliastudios.transcoder.resize.ExactResizer;
import com.otaliastudios.transcoder.resize.MultiResizer;
import com.otaliastudios.transcoder.resize.Resizer;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.source.FileDescriptorDataSource;
import com.otaliastudios.transcoder.source.FilePathDataSource;
import com.otaliastudios.transcoder.source.UriDataSource;
import com.otaliastudios.transcoder.thumbnail.ThumbnailRequest;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001\u001cBC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "", "dataSources", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "resizer", "Lcom/otaliastudios/transcoder/resize/Resizer;", "rotation", "", "thumbnailRequests", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "listener", "Lcom/otaliastudios/transcoder/ThumbnailerListener;", "listenerHandler", "Landroid/os/Handler;", "<init>", "(Ljava/util/List;Lcom/otaliastudios/transcoder/resize/Resizer;ILjava/util/List;Lcom/otaliastudios/transcoder/ThumbnailerListener;Landroid/os/Handler;)V", "getDataSources", "()Ljava/util/List;", "getResizer", "()Lcom/otaliastudios/transcoder/resize/Resizer;", "getRotation", "()I", "getThumbnailRequests", "getListener", "()Lcom/otaliastudios/transcoder/ThumbnailerListener;", "getListenerHandler", "()Landroid/os/Handler;", "Builder", "lib_release"})
public final class ThumbnailerOptions {
    @NotNull
    private final List<DataSource> dataSources;
    @NotNull
    private final Resizer resizer;
    private final int rotation;
    @NotNull
    private final List<ThumbnailRequest> thumbnailRequests;
    @NotNull
    private final ThumbnailerListener listener;
    @NotNull
    private final Handler listenerHandler;

    public ThumbnailerOptions(@NotNull List<? extends DataSource> dataSources, @NotNull Resizer resizer, int rotation, @NotNull List<? extends ThumbnailRequest> thumbnailRequests, @NotNull ThumbnailerListener listener, @NotNull Handler listenerHandler) {
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter((Object)resizer, (String)"resizer");
        Intrinsics.checkNotNullParameter(thumbnailRequests, (String)"thumbnailRequests");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)listenerHandler, (String)"listenerHandler");
        this.dataSources = dataSources;
        this.resizer = resizer;
        this.rotation = rotation;
        this.thumbnailRequests = thumbnailRequests;
        this.listener = listener;
        this.listenerHandler = listenerHandler;
    }

    @NotNull
    public final List<DataSource> getDataSources() {
        return this.dataSources;
    }

    @NotNull
    public final Resizer getResizer() {
        return this.resizer;
    }

    public final int getRotation() {
        return this.rotation;
    }

    @NotNull
    public final List<ThumbnailRequest> getThumbnailRequests() {
        return this.thumbnailRequests;
    }

    @NotNull
    public final ThumbnailerListener getListener() {
        return this.listener;
    }

    @NotNull
    public final Handler getListenerHandler() {
        return this.listenerHandler;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\bJ\u0010\u0010\"\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/otaliastudios/transcoder/ThumbnailerOptions$Builder;", "", "<init>", "()V", "dataSources", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "thumbnailRequests", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "resizer", "Lcom/otaliastudios/transcoder/resize/MultiResizer;", "resizerSet", "", "rotation", "", "listener", "Lcom/otaliastudios/transcoder/ThumbnailerListener;", "listenerHandler", "Landroid/os/Handler;", "addDataSource", "dataSource", "fileDescriptor", "Ljava/io/FileDescriptor;", "filePath", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "addResizer", "Lcom/otaliastudios/transcoder/resize/Resizer;", "setRotation", "addThumbnailRequest", "request", "setListenerHandler", "setListener", "build", "Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "thumbnails", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "lib_release"})
    public static final class Builder {
        @NotNull
        private final List<DataSource> dataSources = new ArrayList();
        @NotNull
        private final List<ThumbnailRequest> thumbnailRequests = new ArrayList();
        @NotNull
        private final MultiResizer resizer = new MultiResizer();
        private boolean resizerSet;
        private int rotation;
        @Nullable
        private ThumbnailerListener listener;
        @Nullable
        private Handler listenerHandler;

        @NotNull
        public final Builder addDataSource(@NotNull DataSource dataSource) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Builder it = builder = this;
            boolean bl = false;
            this.dataSources.add(dataSource);
            return builder;
        }

        @NotNull
        public final Builder addDataSource(@NotNull FileDescriptor fileDescriptor) {
            Intrinsics.checkNotNullParameter((Object)fileDescriptor, (String)"fileDescriptor");
            return this.addDataSource(new FileDescriptorDataSource(fileDescriptor));
        }

        @NotNull
        public final Builder addDataSource(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.addDataSource(new FilePathDataSource(filePath));
        }

        @NotNull
        public final Builder addDataSource(@NotNull Context context, @NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return this.addDataSource(new UriDataSource(context, uri));
        }

        @NotNull
        public final Builder addResizer(@NotNull Resizer resizer) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resizer, (String)"resizer");
            Builder it = builder = this;
            boolean bl = false;
            this.resizer.addResizer(resizer);
            this.resizerSet = true;
            return builder;
        }

        @NotNull
        public final Builder setRotation(int rotation) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.rotation = rotation;
            return builder;
        }

        @NotNull
        public final Builder addThumbnailRequest(@NotNull ThumbnailRequest request) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Builder it = builder = this;
            boolean bl = false;
            this.thumbnailRequests.add(request);
            return builder;
        }

        @NotNull
        public final Builder setListenerHandler(@Nullable Handler listenerHandler) {
            Builder builder;
            Builder it = builder = this;
            boolean bl = false;
            this.listenerHandler = listenerHandler;
            return builder;
        }

        @NotNull
        public final Builder setListener(@NotNull ThumbnailerListener listener) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder it = builder = this;
            boolean bl = false;
            this.listener = listener;
            return builder;
        }

        @NotNull
        public final ThumbnailerOptions build() {
            if (!(!((Collection)this.dataSources).isEmpty())) {
                boolean $i$a$-require-ThumbnailerOptions$Builder$build$32 = false;
                String $i$a$-require-ThumbnailerOptions$Builder$build$32 = "At least one data source is required!";
                throw new IllegalArgumentException($i$a$-require-ThumbnailerOptions$Builder$build$32.toString());
            }
            if (!(!((Collection)this.thumbnailRequests).isEmpty())) {
                boolean $i$a$-require-ThumbnailerOptions$Builder$build$42 = false;
                String $i$a$-require-ThumbnailerOptions$Builder$build$42 = "At least one thumbnail request is required!";
                throw new IllegalArgumentException($i$a$-require-ThumbnailerOptions$Builder$build$42.toString());
            }
            ThumbnailerListener thumbnailerListener = this.listener;
            if (thumbnailerListener == null) {
                boolean $i$a$-requireNotNull-ThumbnailerOptions$Builder$build$listener$22 = false;
                String $i$a$-requireNotNull-ThumbnailerOptions$Builder$build$listener$22 = "Listener can't be null.";
                throw new IllegalArgumentException($i$a$-requireNotNull-ThumbnailerOptions$Builder$build$listener$22.toString());
            }
            ThumbnailerListener listener = thumbnailerListener;
            Handler handler = this.listenerHandler;
            if (handler == null) {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                handler = new Handler(looper);
            }
            Handler listenerHandler = handler;
            Resizer resizer = this.resizerSet ? (Resizer)this.resizer : (Resizer)new ExactResizer(320, 240);
            return new ThumbnailerOptions(CollectionsKt.toList((Iterable)this.dataSources), resizer, this.rotation, CollectionsKt.toList((Iterable)this.thumbnailRequests), listener, listenerHandler);
        }

        @NotNull
        public final Future<Void> thumbnails() {
            return Thumbnailer.Companion.getInstance().thumbnails(this.build());
        }
    }
}

