/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.engine;

import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.runtime.Connector;
import io.debezium.runtime.ConnectorProducer;
import io.debezium.runtime.Debezium;
import io.debezium.runtime.DebeziumConnectorRegistry;
import io.debezium.runtime.EngineManifest;
import io.debezium.runtime.configuration.DebeziumEngineConfiguration;
import io.quarkus.debezium.agroal.engine.AgroalParser;
import io.quarkus.debezium.engine.SourceRecordDebezium;
import io.quarkus.debezium.engine.StateHandler;
import io.quarkus.debezium.engine.capture.consumer.SourceRecordConsumerHandler;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlServerEngineProducer
implements ConnectorProducer {
    public static final Connector SQLSERVER = new Connector(SqlServerConnector.class.getName());
    private final StateHandler stateHandler;
    private final SourceRecordConsumerHandler sourceRecordConsumerHandler;
    private final AgroalParser agroalParser;

    @Inject
    public SqlServerEngineProducer(StateHandler stateHandler, SourceRecordConsumerHandler sourceRecordConsumerHandler, AgroalParser agroalParser) {
        this.stateHandler = stateHandler;
        this.sourceRecordConsumerHandler = sourceRecordConsumerHandler;
        this.agroalParser = agroalParser;
    }

    @Produces
    @Singleton
    public DebeziumConnectorRegistry engine(DebeziumEngineConfiguration debeziumEngineConfiguration) {
        final List multiEngineConfigurations = this.agroalParser.parse(debeziumEngineConfiguration, "mssql", SQLSERVER);
        return new DebeziumConnectorRegistry(){
            private final Map<String, Debezium> engines;
            {
                this.engines = multiEngineConfigurations.stream().map(engine -> {
                    EngineManifest engineManifest = new EngineManifest(engine.engineId());
                    Map debeziumConfiguration = engine.configuration();
                    debeziumConfiguration.remove("database." + JdbcConfiguration.DATABASE.name());
                    return Map.entry(engine.engineId(), new SourceRecordDebezium(engine.configuration(), SqlServerEngineProducer.this.stateHandler, SQLSERVER, SqlServerEngineProducer.this.sourceRecordConsumerHandler.get(engineManifest), engineManifest));
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }

            public Connector connector() {
                return SQLSERVER;
            }

            public Debezium get(EngineManifest manifest) {
                return this.engines.get(manifest.id());
            }

            public List<Debezium> engines() {
                return this.engines.values().stream().toList();
            }
        };
    }
}

