/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network.protocol;

import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.network.protocol.Packet;
import java.io.IOException;

public class GreetingPacket
implements Packet {
    private int protocolVersion;
    private String serverVersion;
    private long threadId;
    private String scramble;
    private int serverCapabilities;
    private int serverCollation;
    private int serverStatus;
    private String pluginProvidedData;

    public GreetingPacket(byte[] bytes) throws IOException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        this.protocolVersion = buffer.readInteger(1);
        this.serverVersion = buffer.readZeroTerminatedString();
        this.threadId = buffer.readLong(4);
        String scramblePrefix = buffer.readZeroTerminatedString();
        this.serverCapabilities = buffer.readInteger(2);
        this.serverCollation = buffer.readInteger(1);
        this.serverStatus = buffer.readInteger(2);
        buffer.skip(13L);
        this.scramble = String.valueOf(scramblePrefix) + buffer.readZeroTerminatedString();
        if (buffer.available() > 0) {
            this.pluginProvidedData = buffer.readZeroTerminatedString();
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getScramble() {
        return this.scramble;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public String getPluginProvidedData() {
        return this.pluginProvidedData;
    }

    public int getServerCollation() {
        return this.serverCollation;
    }
}

