/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util.dns;

import io.debezium.testing.testcontainers.util.dns.FakeDns;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.spi.InetAddressResolver;
import java.net.spi.InetAddressResolverProvider;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeDnsAddressResolverProvider
extends InetAddressResolverProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeDnsAddressResolverProvider.class);

    @Override
    public InetAddressResolver get(InetAddressResolverProvider.Configuration configuration) {
        LOGGER.info("Using Custom Address Resolver : {} ", (Object)this.name());
        LOGGER.info("Registry initialised");
        return new FakeDnsAddressResolver(FakeDns.getInstance(), configuration.builtinResolver());
    }

    @Override
    public String name() {
        return FakeDnsAddressResolver.class.getName();
    }

    public static final class FakeDnsAddressResolver
    implements InetAddressResolver {
        private final InetAddressResolver fallbackResolver;
        private final FakeDns fakeDns;

        public FakeDnsAddressResolver(FakeDns fakeDns, InetAddressResolver fallbackResolver) {
            this.fakeDns = fakeDns;
            this.fallbackResolver = fallbackResolver;
        }

        @Override
        public Stream<InetAddress> lookupByName(String host, InetAddressResolver.LookupPolicy lookupPolicy) throws UnknownHostException {
            Optional<InetAddress> maybeAddress = this.fakeDns.resolve(host);
            return maybeAddress.isPresent() ? maybeAddress.stream() : this.fallbackResolver.lookupByName(host, lookupPolicy);
        }

        @Override
        public String lookupByAddress(byte[] address) throws UnknownHostException {
            Optional<String> maybeHost = this.fakeDns.resolve(address);
            return maybeHost.isPresent() ? maybeHost.get() : this.fallbackResolver.lookupByAddress(address);
        }
    }
}

