/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.awaitility.Awaitility;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DebeziumContainer
extends GenericContainer<DebeziumContainer> {
    private static final int KAFKA_CONNECT_PORT = 8083;
    private final OkHttpClient client = new OkHttpClient();
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public DebeziumContainer(String containerImageName) {
        super(containerImageName);
        this.defaultConfig();
    }

    public DebeziumContainer(Future<String> image) {
        super(image);
        this.defaultConfig();
    }

    private void defaultConfig() {
        this.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/connectors").forPort(8083).forStatusCode(200));
        this.withEnv("GROUP_ID", "1");
        this.withEnv("CONFIG_STORAGE_TOPIC", "debezium_connect_config");
        this.withEnv("OFFSET_STORAGE_TOPIC", "debezium_connect_offsets");
        this.withEnv("STATUS_STORAGE_TOPIC", "debezium_connect_status");
        this.withEnv("CONNECT_KEY_CONVERTER_SCHEMAS_ENABLE", "false");
        this.withEnv("CONNECT_VALUE_CONVERTER_SCHEMAS_ENABLE", "false");
        this.withExposedPorts(new Integer[]{8083});
    }

    public DebeziumContainer withKafka(KafkaContainer kafkaContainer) {
        return this.withKafka(kafkaContainer.getNetwork(), (String)kafkaContainer.getNetworkAliases().get(0) + ":9092");
    }

    public DebeziumContainer withKafka(Network network, String bootstrapServers) {
        this.withNetwork(network);
        this.withEnv("BOOTSTRAP_SERVERS", bootstrapServers);
        return (DebeziumContainer)this.self();
    }

    public void registerConnector(String name, ConnectorConfiguration configuration) throws IOException {
        Connector connector = Connector.from(name, configuration);
        this.registerConnectorToDebezium(connector.toJson(), this.getConnectors());
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> this.isConnectorConfigured(connector.getName()));
    }

    private void registerConnectorToDebezium(String payload, String fullUrl) throws IOException {
        RequestBody body = RequestBody.create((String)payload, (MediaType)JSON);
        Request request = new Request.Builder().url(fullUrl).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response + "Message: " + response.body().string());
            }
        }
    }

    private boolean isConnectorConfigured(String connectorName) throws IOException {
        Request request = new Request.Builder().url(this.getConnector(connectorName)).build();
        try (Response response = this.client.newCall(request).execute();){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    public String getConnectors() {
        return this.getTarget() + "/connectors/";
    }

    public String getConnector(String connectorName) {
        return this.getConnectors() + connectorName;
    }

    public String getConnectorStatus(String connectorName) {
        return this.getConnectors() + connectorName + "/status";
    }

    public String getTarget() {
        return "http://" + this.getContainerIpAddress() + ":" + this.getMappedPort(8083);
    }
}

