/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools;

import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryStatus;
import io.debezium.testing.system.tools.ConfigProperties;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.strimzi.api.kafka.model.kafka.Status;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitConditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitConditions.class);

    public static <T extends Status> boolean kafkaReadyCondition(CustomResource<?, T> resource) {
        Status status = (Status)resource.getStatus();
        if (status == null) {
            return false;
        }
        return status.getConditions().stream().anyMatch(c -> c.getType().equalsIgnoreCase("Ready") && c.getStatus().equalsIgnoreCase("True"));
    }

    public static boolean deploymentAvailableCondition(Deployment resource) {
        DeploymentStatus status = resource.getStatus();
        if (status == null) {
            return false;
        }
        Stream conditions = status.getConditions().stream();
        return conditions.anyMatch(c -> c.getType().equalsIgnoreCase("Available") && c.getStatus().equalsIgnoreCase("True"));
    }

    public static boolean deploymentAvailableCondition(DeploymentConfig resource) {
        DeploymentConfigStatus status = resource.getStatus();
        if (status == null) {
            return false;
        }
        Stream conditions = status.getConditions().stream();
        return conditions.anyMatch(c -> c.getType().equalsIgnoreCase("Available") && c.getStatus().equalsIgnoreCase("True"));
    }

    public static <T extends Status> boolean resourceDeleted(CustomResource<?, T> resource) {
        Status status = (Status)resource.getStatus();
        return status == null;
    }

    public static <T extends ApicurioRegistryStatus> boolean apicurioResourceDeleted(CustomResource<?, T> resource) {
        ApicurioRegistryStatus status = (ApicurioRegistryStatus)resource.getStatus();
        return status == null;
    }

    public static long scaled(long amount) {
        long scaled = ConfigProperties.WAIT_SCALE_FACTOR * amount;
        LOGGER.debug("Waiting amount: " + scaled);
        return scaled;
    }
}

