/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.OperatorController;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrimziOperatorController
extends OperatorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaController.class);
    private static final String DEPLOYMENT_NAME = "strimzi-cluster-operator";

    public static StrimziOperatorController forProject(String project, OpenShiftClient ocp) {
        Deployment operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)ocp.apps().deployments().inNamespace(project)).withName(DEPLOYMENT_NAME)).get();
        return new StrimziOperatorController(operator, ocp);
    }

    private StrimziOperatorController(Deployment operator, OpenShiftClient ocp) {
        super(operator, Collections.singletonMap("strimzi.io/kind", "cluster-operator"), ocp);
    }

    public void setOperandImagePullSecrets(String names) {
        this.setEnvVar("STRIMZI_IMAGE_PULL_SECRETS", names);
    }

    public void unsetOperandImagePullSecrets() {
        this.unsetEnvVar("STRIMZI_IMAGE_PULL_SECRETS");
    }

    public void setLogLevel(String level) {
        this.setEnvVar("STRIMZI_LOG_LEVEL", level);
    }

    public void setOperandAlwaysPullPolicy() {
        this.setEnvVar("STRIMZI_IMAGE_PULL_POLICY", "Always");
    }
}

