/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.registry.AbstractOcpApicurioDeployer;
import io.debezium.testing.system.tools.registry.OcpApicurioController;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpApicurioDeployer
extends AbstractOcpApicurioDeployer<OcpApicurioController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioDeployer.class);
    public static final String APICURIO_CRD_DESCRIPTOR = "/crd/v1/apicurioregistries_crd.yaml";

    private OcpApicurioDeployer(String project, String yamlPath, OpenShiftClient ocp, OkHttpClient http) {
        super(project, yamlPath, ocp, http);
    }

    @Override
    protected NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.apiextensions().v1().customResourceDefinitions().load(OcpApicurioDeployer.class.getResourceAsStream(APICURIO_CRD_DESCRIPTOR))).get();
        CustomResourceDefinitionContext context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        return (NonNamespaceOperation)this.ocp.customResources((ResourceDefinitionContext)context, ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }

    @Override
    protected OcpApicurioController getController(ApicurioRegistry registry) {
        return new OcpApicurioController(registry, this.ocp, this.http);
    }

    public static class Builder
    extends AbstractOcpApicurioDeployer.RegistryBuilder<Builder, OcpApicurioDeployer> {
        @Override
        public OcpApicurioDeployer build() {
            return new OcpApicurioDeployer(this.project, this.yamlPath, this.ocpClient, this.httpClient);
        }
    }
}

