/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectBuilder;
import io.strimzi.api.kafka.model.KafkaConnectFluent;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplate;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpKafkaConnectDeployer
extends AbstractOcpDeployer<OcpKafkaConnectController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaConnectDeployer.class);
    private final String yamlPath;
    private final String cfgYamlPath;
    private final boolean connectorResources;
    private final StrimziOperatorController operatorController;
    private final String pullSecretName;
    private final boolean exposedApi;
    private final boolean exposedMetrics;

    private OcpKafkaConnectDeployer(String project, String yamlPath, String cfgYamlPath, boolean connectorResources, StrimziOperatorController operatorController, boolean exposedApi, boolean exposedMetrics, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.yamlPath = yamlPath;
        this.cfgYamlPath = cfgYamlPath;
        this.connectorResources = connectorResources;
        this.operatorController = operatorController;
        this.pullSecretName = operatorController.getPullSecretName();
        this.exposedApi = exposedApi;
        this.exposedMetrics = exposedMetrics;
    }

    @Override
    public OcpKafkaConnectController deploy() throws InterruptedException {
        LOGGER.info("Deploying KafkaConnect from " + this.yamlPath);
        KafkaConnect kafkaConnect = YAML.fromResource(this.yamlPath, KafkaConnect.class);
        Build kcBuild = kafkaConnect.getSpec().getBuild();
        KafkaConnectBuilder kcBuilder = new KafkaConnectBuilder(kafkaConnect);
        if (this.cfgYamlPath != null) {
            this.deployConfigMap();
        }
        if (this.connectorResources) {
            this.configureConnectorResources(kcBuilder);
        }
        if (this.pullSecretName != null) {
            this.configurePullSecret(kcBuilder, kcBuild);
        }
        if (kcBuild != null && "imagestream".equals(kcBuild.getOutput().getType())) {
            this.deployImageStream(kcBuild);
        }
        kafkaConnect = kcBuilder.build();
        kafkaConnect = (KafkaConnect)this.kafkaConnectOperation().createOrReplace((Object[])new KafkaConnect[]{kafkaConnect});
        OcpKafkaConnectController controller = new OcpKafkaConnectController(kafkaConnect, this.operatorController, this.ocp, this.http, this.connectorResources);
        controller.waitForCluster();
        return controller;
    }

    private void deployConfigMap() {
        ((NonNamespaceOperation)this.ocp.configMaps().inNamespace(this.project)).createOrReplace((Object[])new ConfigMap[]{YAML.fromResource(this.cfgYamlPath, ConfigMap.class)});
    }

    private void deployImageStream(Build kcBuild) {
        String[] image = kcBuild.getOutput().getImage().split(":", 2);
        ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(image[0])).endMetadata()).withNewSpec().withNewLookupPolicy(Boolean.valueOf(true))).endSpec()).build();
        ((NonNamespaceOperation)this.ocp.imageStreams().inNamespace(this.project)).createOrReplace((Object[])new ImageStream[]{is});
    }

    private void configurePullSecret(KafkaConnectBuilder kcBuilder, Build kcBuild) {
        KafkaConnectTemplate template = kcBuilder.buildSpec().getTemplate();
        KafkaConnectTemplateBuilder templateBuilder = new KafkaConnectTemplateBuilder(template);
        if (kcBuild == null) {
            ((KafkaConnectTemplateFluent.PodNested)templateBuilder.withNewPod().addNewImagePullSecret(this.pullSecretName)).endPod();
        } else {
            ((KafkaConnectTemplateFluent.BuildConfigNested)templateBuilder.withNewBuildConfig().withPullSecret(this.pullSecretName)).endBuildConfig();
        }
        ((KafkaConnectFluent.SpecNested)kcBuilder.editSpec().withTemplate(templateBuilder.build())).endSpec();
    }

    private void configureConnectorResources(KafkaConnectBuilder kcBuilder) {
        ((KafkaConnectFluent.MetadataNested)kcBuilder.editMetadata().addToAnnotations("strimzi.io/use-connector-resources", "true")).endMetadata();
    }

    private NonNamespaceOperation<KafkaConnect, KafkaConnectList, Resource<KafkaConnect>> kafkaConnectOperation() {
        return (NonNamespaceOperation)Crds.kafkaConnectOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpKafkaConnectDeployer> {
        private String project;
        private String yamlPath;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private String cfgYamlPath;
        private boolean connectorResources;
        private boolean exposedMetrics;
        private boolean exposedApi;
        private StrimziOperatorController operatorController;

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withYamlPath(String yamlPath) {
            this.yamlPath = yamlPath;
            return this;
        }

        public Builder withCfgYamlPath(String cfgYamlPath) {
            this.cfgYamlPath = cfgYamlPath;
            return this;
        }

        public Builder withConnectorResources(boolean value) {
            this.connectorResources = value;
            return this;
        }

        public Builder withExposedApi(boolean value) {
            this.exposedApi = value;
            return this;
        }

        public Builder withExposedMetrics(boolean value) {
            this.exposedMetrics = value;
            return this;
        }

        public Builder withOperatorController(StrimziOperatorController operatorController) {
            this.operatorController = operatorController;
            return this;
        }

        @Override
        public OcpKafkaConnectDeployer build() {
            return new OcpKafkaConnectDeployer(this.project, this.yamlPath, this.cfgYamlPath, this.connectorResources, this.operatorController, this.exposedApi, this.exposedMetrics, this.ocpClient, this.httpClient);
        }
    }
}

