/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.db2;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.OcpSqlDatabaseController;
import io.debezium.testing.system.tools.databases.SqlDatabaseClient;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.openshift.client.OpenShiftClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpDB2Controller
extends OcpSqlDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpDB2Controller.class);
    private static final String READINESS_SQL_SELECT = "SELECT 1 FROM DB2INST1.CUSTOMERS;";

    public OcpDB2Controller(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        super(deployment, services, "db2", ocp);
    }

    @Override
    public void initialize() {
        LOGGER.info("Waiting until DB2 instance is ready");
        Object client = this.getDatabaseClient(ConfigProperties.DATABASE_DB2_DBZ_USERNAME, ConfigProperties.DATABASE_DB2_DBZ_PASSWORD);
        try (Connection connection = ((SqlDatabaseClient)client).connect();){
            LOGGER.info("Database connection established successfully!");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPublicDatabaseUrl() {
        return super.getPublicDatabaseUrl() + ConfigProperties.DATABASE_DB2_DBZ_DBNAME;
    }
}

