/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

public class SmtOverheadPerf {
    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void newRecord(TransformState state) {
        state.newRecord.apply((ConnectRecord)state.create);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void noop(TransformState state) {
        state.noop.apply((ConnectRecord)state.create);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=2, timeUnit=TimeUnit.SECONDS)
    public void base(TransformState state) {
    }

    @State(value=Scope.Thread)
    public static class TransformState {
        public Transformation<SourceRecord> newRecord;
        public Transformation<SourceRecord> noop;
        public SourceRecord delete;
        public SourceRecord create;

        @Setup(value=Level.Trial)
        public void doSetup() {
            Schema schema = SchemaBuilder.struct().name("dummyenv").field("op", Schema.STRING_SCHEMA).build();
            Struct deleteValue = new Struct(schema);
            deleteValue.put("op", (Object)"d");
            this.delete = new SourceRecord(new HashMap(), new HashMap(), "top1", Integer.valueOf(1), schema, (Object)this.delete);
            Struct createValue = new Struct(schema);
            createValue.put("op", (Object)"c");
            this.create = new SourceRecord(new HashMap(), new HashMap(), "top1", Integer.valueOf(1), schema, (Object)this.create);
            this.newRecord = new NewRecord();
            this.newRecord.configure(new HashMap());
            this.noop = new NoOp();
            this.noop.configure(new HashMap());
        }
    }

    private static class NoOp
    implements Transformation<SourceRecord> {
        private NoOp() {
        }

        public void configure(Map<String, ?> configs) {
        }

        public SourceRecord apply(SourceRecord record) {
            return record;
        }

        public ConfigDef config() {
            return null;
        }

        public void close() {
        }
    }

    private static class NewRecord
    implements Transformation<SourceRecord> {
        private NewRecord() {
        }

        public void configure(Map<String, ?> configs) {
        }

        public SourceRecord apply(SourceRecord record) {
            return record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp(), (Iterable)record.headers());
        }

        public ConfigDef config() {
            return null;
        }

        public void close() {
        }
    }
}

