/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.tracing;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryInterceptorVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryInterceptorVersion.class);
    private final String className;
    private Class<?> interceptorClass;

    public OpenTelemetryInterceptorVersion(String className) {
        this.className = className;
        try {
            this.interceptorClass = Class.forName(className);
            LOGGER.debug("Class {} found", (Object)className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Class {} not found", (Object)className);
            this.interceptorClass = null;
        }
    }

    public Object createInstance() {
        if (this.interceptorClass == null) {
            return null;
        }
        try {
            return this.interceptorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to instantiate {}", (Object)this.className, (Object)e);
            return null;
        }
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) {
        if (this.interceptorClass == null) {
            return null;
        }
        try {
            return this.interceptorClass.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            LOGGER.debug("Unable to get method {} from {}", new Object[]{name, this.className, e});
            return null;
        }
    }
}

