/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Field;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDefaultValueConverter;
import io.debezium.connector.sqlserver.SqlServerJdbcConfiguration;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.data.Envelope;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnection
extends JdbcConnection {
    public static final String INSTANCE_NAME = "instance";
    private static final String GET_DATABASE_NAME = "SELECT name FROM sys.databases WHERE name = ?";
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnection.class);
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String DATABASE_NAME_PLACEHOLDER = "#db";
    private static final String TABLE_NAME_PLACEHOLDER = "#table";
    private static final String FUNCTION_NAME_PLACEHOLDER = "#function";
    private static final String GET_ALL_CHANGES_FUNCTION_PREFIX = "fn_cdc_get_all_changes_";
    private static final String GET_MAX_LSN = "SELECT #db.sys.fn_cdc_get_max_lsn()";
    private static final String GET_MAX_TRANSACTION_LSN = "SELECT MAX(start_lsn) FROM #db.cdc.lsn_time_mapping WHERE tran_id <> 0x00";
    private static final String GET_NTH_TRANSACTION_LSN_FROM_BEGINNING = "SELECT MAX(start_lsn) FROM (SELECT TOP (?) start_lsn FROM #db.cdc.lsn_time_mapping WHERE tran_id <> 0x00 ORDER BY start_lsn) as next_lsns";
    private static final String GET_NTH_TRANSACTION_LSN_FROM_LAST = "SELECT MAX(start_lsn) FROM (SELECT TOP (? + 1) start_lsn FROM #db.cdc.lsn_time_mapping WHERE start_lsn >= ? AND tran_id <> 0x00 ORDER BY start_lsn) as next_lsns";
    private static final String GET_MIN_LSN = "SELECT #db.sys.fn_cdc_get_min_lsn(?)";
    private static final String LOCK_TABLE = "SELECT * FROM #table WITH (TABLOCKX)";
    private static final String INCREMENT_LSN = "SELECT #db.sys.fn_cdc_increment_lsn(?)";
    protected static final String LSN_TIMESTAMP_SELECT_STATEMENT = "TODATETIMEOFFSET(#db.sys.fn_cdc_map_lsn_to_time([__$start_lsn]), DATEPART(TZOFFSET, SYSDATETIMEOFFSET()))";
    private static final String GET_ALL_CHANGES_FOR_TABLE_SELECT = "SELECT [__$start_lsn], [__$seqval], [__$operation], [__$update_mask], #, TODATETIMEOFFSET(#db.sys.fn_cdc_map_lsn_to_time([__$start_lsn]), DATEPART(TZOFFSET, SYSDATETIMEOFFSET()))";
    private static final String GET_ALL_CHANGES_FOR_TABLE_FROM_FUNCTION = "FROM #db.cdc.#function(?, ?, N'all update old')";
    private static final String GET_ALL_CHANGES_FOR_TABLE_FROM_DIRECT = "FROM #db.cdc.#table";
    private static final String GET_ALL_CHANGES_FOR_TABLE_FROM_FUNCTION_ORDER_BY = "ORDER BY [__$start_lsn] ASC, [__$seqval] ASC, [__$operation] ASC";
    private static final String GET_ALL_CHANGES_FOR_TABLE_FROM_DIRECT_ORDER_BY = "ORDER BY [__$start_lsn] ASC, [__$command_id] ASC, [__$seqval] ASC, [__$operation] ASC";
    private static final String GET_CAPTURED_COLUMNS = "SELECT object_id, column_name FROM #db.cdc.captured_columns ORDER BY object_id, column_id";
    private static final String GET_CHANGE_TABLES = "WITH ordered_change_tables AS (SELECT ROW_NUMBER() OVER (PARTITION BY ct.source_object_id, ct.start_lsn ORDER BY ct.create_date DESC) AS ct_sequence, ct.* FROM #db.cdc.change_tables AS ct#) SELECT OBJECT_SCHEMA_NAME(source_object_id, DB_ID(?)), OBJECT_NAME(source_object_id, DB_ID(?)), capture_instance, object_id, start_lsn FROM ordered_change_tables WHERE ct_sequence = 1";
    private static final String GET_NEW_CHANGE_TABLES = "SELECT * FROM #db.cdc.change_tables WHERE start_lsn BETWEEN ? AND ?";
    private static final String GET_MIN_LSN_FROM_ALL_CHANGE_TABLES = "select min(start_lsn) from #db.cdc.change_tables";
    private static final String OPENING_QUOTING_CHARACTER = "[";
    private static final String CLOSING_QUOTING_CHARACTER = "]";
    private static final String URL_PATTERN = "jdbc:sqlserver://${" + String.valueOf(JdbcConfiguration.HOSTNAME) + "}";
    private final SqlServerConnectorConfig config;
    private final boolean useSingleDatabase;
    private final String getAllChangesForTable;
    private final int queryFetchSize;
    private final SqlServerDefaultValueConverter defaultValueConverter;
    private boolean optionRecompile;
    private static final Field AGENT_STATUS_QUERY = Field.create((String)"sqlserver.agent.status.query").withDescription("Query to get the running status of the SQL Server Agent").withDefault("SELECT CASE WHEN dss.[status]=4 THEN 1 ELSE 0 END AS isRunning FROM #db.sys.dm_server_services dss WHERE dss.[servicename] LIKE N'SQL Server Agent (%';");

    public SqlServerConnection(SqlServerConnectorConfig config, SqlServerValueConverters valueConverters, Set<Envelope.Operation> skippedOperations, boolean useSingleDatabase) {
        super((JdbcConfiguration)config.getJdbcConfig(), SqlServerConnection.createConnectionFactory(config.getJdbcConfig(), useSingleDatabase), OPENING_QUOTING_CHARACTER, CLOSING_QUOTING_CHARACTER);
        this.defaultValueConverter = new SqlServerDefaultValueConverter(() -> ((SqlServerConnection)this).connection(), valueConverters);
        this.queryFetchSize = config.getQueryFetchSize();
        this.getAllChangesForTable = this.buildGetAllChangesForTableQuery(config.getDataQueryMode(), skippedOperations);
        this.config = config;
        this.useSingleDatabase = useSingleDatabase;
        this.optionRecompile = false;
    }

    public SqlServerConnection(SqlServerConnectorConfig config, SqlServerValueConverters valueConverters, Set<Envelope.Operation> skippedOperations, boolean useSingleDatabase, boolean optionRecompile) {
        this(config, valueConverters, skippedOperations, useSingleDatabase);
        this.optionRecompile = optionRecompile;
    }

    private String buildGetAllChangesForTableQuery(SqlServerConnectorConfig.DataQueryMode dataQueryMode, Set<Envelope.Operation> skippedOperations) {
        Object result = "SELECT [__$start_lsn], [__$seqval], [__$operation], [__$update_mask], #, TODATETIMEOFFSET(#db.sys.fn_cdc_map_lsn_to_time([__$start_lsn]), DATEPART(TZOFFSET, SYSDATETIMEOFFSET())) ";
        LinkedList<Object> where = new LinkedList<Object>();
        switch (dataQueryMode) {
            case FUNCTION: {
                result = (String)result + "FROM #db.cdc.#function(?, ?, N'all update old') ";
                break;
            }
            case DIRECT: {
                result = (String)result + "FROM #db.cdc.#table ";
            }
        }
        where.add("(([__$start_lsn] = ? AND [__$seqval] = ? AND [__$operation] > ?) OR ([__$start_lsn] = ? AND [__$seqval] > ?) OR ([__$start_lsn] > ?))");
        where.add("[__$start_lsn] <= ?");
        if (this.hasSkippedOperations(skippedOperations)) {
            HashSet skippedOps = new HashSet();
            skippedOperations.forEach(operation -> {
                switch (operation) {
                    case CREATE: {
                        skippedOps.add("2");
                        break;
                    }
                    case UPDATE: {
                        skippedOps.add("3");
                        skippedOps.add("4");
                        break;
                    }
                    case DELETE: {
                        skippedOps.add("1");
                    }
                }
            });
            where.add("[__$operation] NOT IN (" + String.join((CharSequence)",", skippedOps) + ")");
        }
        if (!where.isEmpty()) {
            result = (String)result + " WHERE " + String.join((CharSequence)" AND ", where) + " ";
        }
        switch (dataQueryMode) {
            case FUNCTION: {
                result = (String)result + GET_ALL_CHANGES_FOR_TABLE_FROM_FUNCTION_ORDER_BY;
                break;
            }
            case DIRECT: {
                result = (String)result + GET_ALL_CHANGES_FOR_TABLE_FROM_DIRECT_ORDER_BY;
            }
        }
        return result;
    }

    private boolean hasSkippedOperations(Set<Envelope.Operation> skippedOperations) {
        if (!skippedOperations.isEmpty()) {
            for (Envelope.Operation operation : skippedOperations) {
                switch (operation) {
                    case CREATE: 
                    case UPDATE: 
                    case DELETE: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static JdbcConnection.ConnectionFactory createConnectionFactory(SqlServerJdbcConfiguration config, boolean useSingleDatabase) {
        return JdbcConnection.patternBasedFactory((String)SqlServerConnection.createUrlPattern(config, useSingleDatabase), (String)SQLServerDriver.class.getName(), (ClassLoader)SqlServerConnection.class.getClassLoader(), (Field[])new Field[]{JdbcConfiguration.PORT.withDefault(SqlServerConnectorConfig.PORT.defaultValueAsString())});
    }

    protected static String createUrlPattern(SqlServerJdbcConfiguration config, boolean useSingleDatabase) {
        Object pattern = URL_PATTERN;
        if (config.getInstance() != null) {
            pattern = (String)pattern + "\\" + config.getInstance();
            if (config.getPortAsString() != null) {
                pattern = (String)pattern + ":${" + String.valueOf(JdbcConfiguration.PORT) + "}";
            }
        } else {
            pattern = (String)pattern + ":${" + String.valueOf(JdbcConfiguration.PORT) + "}";
        }
        if (useSingleDatabase) {
            pattern = (String)pattern + ";databaseName=${" + String.valueOf(JdbcConfiguration.DATABASE) + "}";
        }
        return pattern;
    }

    protected Set<Character> getLikeWildcardCharacters() {
        return Stream.concat(super.getLikeWildcardCharacters().stream(), Stream.of(Character.valueOf('['))).collect(Collectors.toUnmodifiableSet());
    }

    public String connectionString() {
        return this.connectionString(SqlServerConnection.createUrlPattern(this.config.getJdbcConfig(), this.useSingleDatabase));
    }

    public synchronized Connection connection(boolean executeOnConnect) throws SQLException {
        boolean connected = this.isConnected();
        Connection connection = super.connection(executeOnConnect);
        if (!connected) {
            connection.setAutoCommit(false);
        }
        return connection;
    }

    public Lsn getMaxLsn(String databaseName) throws SQLException {
        return (Lsn)this.queryAndMap(this.replaceDatabaseNamePlaceholder(GET_MAX_LSN, databaseName), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public Lsn getNthTransactionLsnFromBeginning(String databaseName, int maxOffset) throws SQLException {
        return (Lsn)this.prepareQueryAndMap(this.replaceDatabaseNamePlaceholder(GET_NTH_TRANSACTION_LSN_FROM_BEGINNING, databaseName), statement -> statement.setInt(1, maxOffset), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Nth lsn from beginning is {}", (Object)ret);
            return ret;
        }, "Nth LSN query must return exactly one value"));
    }

    public Lsn getNthTransactionLsnFromLast(String databaseName, Lsn lastLsn, int maxOffset) throws SQLException {
        return (Lsn)this.prepareQueryAndMap(this.replaceDatabaseNamePlaceholder(GET_NTH_TRANSACTION_LSN_FROM_LAST, databaseName), statement -> {
            statement.setInt(1, maxOffset);
            statement.setBytes(2, lastLsn.getBinary());
        }, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Nth lsn from last is {}", (Object)ret);
            return ret;
        }, "Nth LSN query must return exactly one value"));
    }

    public Lsn getMaxTransactionLsn(String databaseName) throws SQLException {
        return (Lsn)this.queryAndMap(this.replaceDatabaseNamePlaceholder(GET_MAX_TRANSACTION_LSN, databaseName), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Max transaction lsn is {}", (Object)ret);
            return ret;
        }, "Max transaction LSN query must return exactly one value"));
    }

    public Lsn getMinLsn(String databaseName, String changeTableName) throws SQLException {
        String query = this.replaceDatabaseNamePlaceholder(GET_MIN_LSN, databaseName);
        return (Lsn)this.prepareQueryAndMap(query, preparer -> preparer.setString(1, changeTableName), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current minimum lsn is {}", (Object)ret);
            return ret;
        }, "Minimum LSN query must return exactly one value"));
    }

    public ResultSet getChangesForTable(SqlServerChangeTable changeTable, Lsn intervalFromLsn, Lsn seqvalFromLsn, int operationFrom, Lsn intervalToLsn, int maxRows) throws SQLException {
        String databaseName = changeTable.getSourceTableId().catalog();
        String capturedColumns = changeTable.getCapturedColumns().stream().map(arg_0 -> ((SqlServerConnection)this).quoteIdentifier(arg_0)).collect(Collectors.joining(", "));
        String query = this.replaceDatabaseNamePlaceholder(this.getAllChangesForTable, databaseName).replaceFirst(STATEMENTS_PLACEHOLDER, Matcher.quoteReplacement(capturedColumns));
        switch (this.config.getDataQueryMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FUNCTION: {
                String string = query.replace(FUNCTION_NAME_PLACEHOLDER, this.quoteIdentifier(GET_ALL_CHANGES_FUNCTION_PREFIX.concat(changeTable.getCaptureInstance())));
                break;
            }
            case DIRECT: {
                String string = query = query.replace(TABLE_NAME_PLACEHOLDER, this.quoteIdentifier(changeTable.getChangeTableId().table()));
            }
        }
        if (maxRows > 0) {
            query = query.replace("SELECT ", String.format("SELECT TOP %d ", maxRows));
        }
        Lsn fromLsn = this.getFromLsn(changeTable, intervalFromLsn);
        LOGGER.trace("Getting {} changes for table {} in range [{}-{}-{}, {}]", new Object[]{maxRows > 0 ? "top " + maxRows : "", changeTable, fromLsn, seqvalFromLsn, operationFrom, intervalToLsn});
        PreparedStatement statement = this.connection().prepareStatement(query);
        statement.closeOnCompletion();
        if (this.queryFetchSize > 0) {
            statement.setFetchSize(this.queryFetchSize);
        }
        int paramIndex = 1;
        if (this.config.getDataQueryMode() == SqlServerConnectorConfig.DataQueryMode.FUNCTION) {
            statement.setBytes(paramIndex++, fromLsn.getBinary());
            statement.setBytes(paramIndex++, intervalToLsn.getBinary());
        }
        statement.setBytes(paramIndex++, fromLsn.getBinary());
        statement.setBytes(paramIndex++, seqvalFromLsn.getBinary());
        statement.setInt(paramIndex++, operationFrom);
        statement.setBytes(paramIndex++, fromLsn.getBinary());
        statement.setBytes(paramIndex++, seqvalFromLsn.getBinary());
        statement.setBytes(paramIndex++, fromLsn.getBinary());
        statement.setBytes(paramIndex++, intervalToLsn.getBinary());
        return statement.executeQuery();
    }

    public ResultSet getChangesForTable(SqlServerChangeTable changeTable, Lsn intervalFromLsn, Lsn intervalToLsn, int maxRows) throws SQLException {
        return this.getChangesForTable(changeTable, intervalFromLsn, Lsn.ZERO, 0, intervalToLsn, maxRows);
    }

    public ResultSet getChangesForTable(SqlServerChangeTable changeTable, Lsn intervalFromLsn, Lsn intervalToLsn) throws SQLException {
        return this.getChangesForTable(changeTable, intervalFromLsn, intervalToLsn, 0);
    }

    private Lsn getFromLsn(SqlServerChangeTable changeTable, Lsn intervalFromLsn) throws SQLException {
        Lsn fromLsn = changeTable.getStartLsn().compareTo(intervalFromLsn) > 0 ? changeTable.getStartLsn() : intervalFromLsn;
        return fromLsn.getBinary() != null ? fromLsn : this.getMinLsn(changeTable.getSourceTableId().catalog(), changeTable.getCaptureInstance());
    }

    public Lsn incrementLsn(String databaseName, Lsn lsn) throws SQLException {
        return (Lsn)this.prepareQueryAndMap(this.replaceDatabaseNamePlaceholder(INCREMENT_LSN, databaseName), statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Increasing lsn from {} to {}", (Object)lsn, (Object)ret);
            return ret;
        }, "Increment LSN query must return exactly one value"));
    }

    public boolean checkIfConnectedUserHasAccessToCDCTable(String databaseName) throws SQLException {
        AtomicBoolean userHasAccess = new AtomicBoolean();
        String query = this.replaceDatabaseNamePlaceholder("EXEC #db.sys.sp_cdc_help_change_data_capture", databaseName);
        this.query(query, rs -> userHasAccess.set(rs.next()));
        return userHasAccess.get();
    }

    public List<SqlServerChangeTable> getChangeTables(String databaseName) throws SQLException {
        return this.getChangeTables(databaseName, Lsn.NULL);
    }

    public List<SqlServerChangeTable> getChangeTables(String databaseName, Lsn toLsn) throws SQLException {
        Map columns = (Map)this.queryAndMap(this.replaceDatabaseNamePlaceholder(GET_CAPTURED_COLUMNS, databaseName), rs -> {
            HashMap result = new HashMap();
            while (rs.next()) {
                int changeTableObjectId = rs.getInt(1);
                if (!result.containsKey(changeTableObjectId)) {
                    result.put(changeTableObjectId, new LinkedList());
                }
                ((List)result.get(changeTableObjectId)).add(rs.getString(2));
            }
            return result;
        });
        JdbcConnection.ResultSetMapper mapper = rs -> {
            ArrayList<SqlServerChangeTable> changeTables = new ArrayList<SqlServerChangeTable>();
            while (rs.next()) {
                int changeTableObjectId = rs.getInt(4);
                changeTables.add(new SqlServerChangeTable(new TableId(databaseName, rs.getString(1), rs.getString(2)), rs.getString(3), changeTableObjectId, Lsn.valueOf(rs.getBytes(5)), (List)columns.get(changeTableObjectId)));
            }
            return changeTables;
        };
        String query = this.replaceDatabaseNamePlaceholder(GET_CHANGE_TABLES, databaseName);
        if (toLsn.isAvailable()) {
            return (List)this.prepareQueryAndMap(query.replace(STATEMENTS_PLACEHOLDER, " WHERE ct.start_lsn <= ?"), ps -> {
                ps.setBytes(1, toLsn.getBinary());
                ps.setString(2, databaseName);
                ps.setString(3, databaseName);
            }, mapper);
        }
        return (List)this.prepareQueryAndMap(query.replace(STATEMENTS_PLACEHOLDER, ""), ps -> {
            ps.setString(1, databaseName);
            ps.setString(2, databaseName);
        }, mapper);
    }

    public List<SqlServerChangeTable> getNewChangeTables(String databaseName, Lsn fromLsn, Lsn toLsn) throws SQLException {
        String query = this.replaceDatabaseNamePlaceholder(GET_NEW_CHANGE_TABLES, databaseName);
        return (List)this.prepareQueryAndMap(query, ps -> {
            ps.setBytes(1, fromLsn.getBinary());
            ps.setBytes(2, toLsn.getBinary());
        }, rs -> {
            ArrayList<SqlServerChangeTable> changeTables = new ArrayList<SqlServerChangeTable>();
            while (rs.next()) {
                changeTables.add(new SqlServerChangeTable(rs.getString(4), rs.getInt(1), Lsn.valueOf(rs.getBytes(5))));
            }
            return changeTables;
        });
    }

    public Table getTableSchemaFromTable(String databaseName, SqlServerChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        ArrayList columns = new ArrayList();
        try (ResultSet rs = metadata.getColumns(databaseName, changeTable.getSourceTableId().schema(), changeTable.getSourceTableId().table(), null);){
            while (rs.next()) {
                this.readTableColumn(rs, changeTable.getSourceTableId(), null).ifPresent(ce -> {
                    if (changeTable.getCapturedColumns().contains(ce.name())) {
                        columns.add(ce.create());
                    }
                });
            }
        }
        List pkColumnNames = this.readPrimaryKeyOrUniqueIndexNames(metadata, changeTable.getSourceTableId()).stream().filter(column -> changeTable.getCapturedColumns().contains(column)).collect(Collectors.toList());
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public String getNameOfChangeTable(String captureName) {
        return captureName + "_CT";
    }

    public String retrieveRealDatabaseName(String databaseName) {
        try {
            return (String)this.prepareQueryAndMap(GET_DATABASE_NAME, ps -> ps.setString(1, databaseName), this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve exactly one database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    protected boolean isTableUniqueIndexIncluded(String indexName, String columnName) {
        return indexName != null;
    }

    public Object getColumnValue(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnType = metaData.getColumnType(columnIndex);
        if (columnType == 92) {
            return rs.getTimestamp(columnIndex);
        }
        return super.getColumnValue(rs, columnIndex, column, table);
    }

    public void setQueryColumnValue(PreparedStatement statement, Column column, int pos, Object value) throws SQLException {
        if (column.typeUsesCharset()) {
            switch (column.jdbcType()) {
                case -15: {
                    if (value instanceof String) {
                        statement.setNString(pos, (String)value);
                        break;
                    }
                    super.setQueryColumnValue(statement, column, pos, value);
                    break;
                }
                case -9: {
                    if (value instanceof String) {
                        statement.setNCharacterStream(pos, new StringReader((String)value));
                        break;
                    }
                    if (value instanceof Reader) {
                        statement.setNCharacterStream(pos, (Reader)value);
                        break;
                    }
                    super.setQueryColumnValue(statement, column, pos, value);
                    break;
                }
                case -16: {
                    if (value instanceof String) {
                        statement.setNCharacterStream(pos, new StringReader((String)value));
                        break;
                    }
                    if (value instanceof Reader) {
                        statement.setNCharacterStream(pos, (Reader)value);
                        break;
                    }
                    if (value instanceof NClob) {
                        statement.setNClob(pos, (NClob)value);
                        break;
                    }
                    super.setQueryColumnValue(statement, column, pos, value);
                    break;
                }
                default: {
                    super.setQueryColumnValue(statement, column, pos, value);
                    break;
                }
            }
        } else {
            super.setQueryColumnValue(statement, column, pos, value);
        }
    }

    public String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, Optional<String> additionalCondition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT TOP ");
        sql.append(limit).append(' ').append(projection).append(" FROM ");
        sql.append(this.quotedTableIdString(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
            if (additionalCondition.isPresent()) {
                sql.append(" AND ");
                sql.append(additionalCondition.get());
            }
        } else if (additionalCondition.isPresent()) {
            sql.append(" WHERE ");
            sql.append(additionalCondition.get());
        }
        sql.append(" ORDER BY ").append(orderBy);
        if (this.optionRecompile) {
            sql.append(" OPTION(RECOMPILE)");
        }
        return sql.toString();
    }

    public Optional<Boolean> nullsSortLast() {
        return Optional.of(false);
    }

    public String quotedTableIdString(TableId tableId) {
        return Stream.of(tableId.catalog(), tableId.schema(), tableId.table()).map(arg_0 -> ((SqlServerConnection)this).quoteIdentifier(arg_0)).collect(Collectors.joining("."));
    }

    private String replaceDatabaseNamePlaceholder(String sql, String databaseName) {
        return sql.replace(DATABASE_NAME_PLACEHOLDER, this.quoteIdentifier(databaseName));
    }

    public SqlServerDefaultValueConverter getDefaultValueConverter() {
        return this.defaultValueConverter;
    }

    public boolean isAgentRunning(String databaseName) throws SQLException {
        String query = this.replaceDatabaseNamePlaceholder(this.config().getString(AGENT_STATUS_QUERY), databaseName);
        return (Boolean)this.queryAndMap(query, this.singleResultMapper(rs -> rs.getBoolean(1), "SQL Server Agent running status query must return exactly one value"));
    }

    public Optional<Instant> getCurrentTimestamp() throws SQLException {
        return (Optional)this.queryAndMap("SELECT SYSDATETIMEOFFSET()", rs -> rs.next() ? Optional.of(rs.getObject(1, OffsetDateTime.class).toInstant()) : Optional.empty());
    }

    public boolean validateLogPosition(Partition partition, OffsetContext offset, CommonConnectorConfig config) {
        Lsn storedLsn = ((SqlServerOffsetContext)offset).getChangePosition().getCommitLsn();
        String oldestFirstChangeQuery = this.replaceDatabaseNamePlaceholder(GET_MIN_LSN_FROM_ALL_CHANGE_TABLES, ((SqlServerPartition)partition).getDatabaseName());
        try {
            String oldestScn = (String)this.singleOptionalValue(oldestFirstChangeQuery, rs -> rs.getString(1));
            if (oldestScn == null) {
                return false;
            }
            LOGGER.trace("Oldest SCN in logs is '{}'", (Object)oldestScn);
            return storedLsn == null || Lsn.valueOf(oldestScn).compareTo(storedLsn) < 0;
        }
        catch (SQLException e) {
            throw new DebeziumException("Unable to get last available log position", (Throwable)e);
        }
    }

    public <T> T singleOptionalValue(String query, JdbcConnection.ResultSetExtractor<T> extractor) throws SQLException {
        return (T)this.queryAndMap(query, rs -> rs.next() ? extractor.apply(rs) : null);
    }
}

