/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.schema.SchemaChangeEvent;

public class SqlServerSchemaChangeEventEmitter
implements SchemaChangeEventEmitter {
    private final SqlServerPartition partition;
    private final SqlServerOffsetContext offsetContext;
    private final SqlServerChangeTable changeTable;
    private final Table tableSchema;
    private final SqlServerDatabaseSchema schema;
    private final SchemaChangeEvent.SchemaChangeEventType eventType;

    public SqlServerSchemaChangeEventEmitter(SqlServerPartition partition, SqlServerOffsetContext offsetContext, SqlServerChangeTable changeTable, Table tableSchema, SqlServerDatabaseSchema schema, SchemaChangeEvent.SchemaChangeEventType eventType) {
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.changeTable = changeTable;
        this.tableSchema = tableSchema;
        this.schema = schema;
        this.eventType = eventType;
    }

    public void emitSchemaChangeEvent(SchemaChangeEventEmitter.Receiver receiver) throws InterruptedException {
        SchemaChangeEvent event = SchemaChangeEvent.of((SchemaChangeEvent.SchemaChangeEventType)this.eventType, (Partition)this.partition, (OffsetContext)this.offsetContext, (String)this.changeTable.getSourceTableId().catalog(), (String)this.changeTable.getSourceTableId().schema(), (String)"N/A", (Table)this.tableSchema, (boolean)false);
        if (!this.schema.skipSchemaChangeEvent(event)) {
            receiver.schemaChangeEvent(event);
        }
    }
}

