/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerJdbcConfiguration;
import io.debezium.connector.sqlserver.SqlServerSourceInfoStructMaker;
import io.debezium.connector.sqlserver.SqlServerTableIdPredicates;
import io.debezium.document.Document;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.TableIdPredicates;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorConfig.class);
    public static final String MAX_TRANSACTIONS_PER_ITERATION_CONFIG_NAME = "max.iteration.transactions";
    public static final String ERRORS_MAX_RETRIES = "errors.max.retries";
    protected static final int DEFAULT_PORT = 1433;
    protected static final int DEFAULT_MAX_TRANSACTIONS_PER_ITERATION = 0;
    protected static final int DEFAULT_MAX_RETRIES = -1;
    private static final String READ_ONLY_INTENT = "ReadOnly";
    private static final String APPLICATION_INTENT_KEY = "database.applicationIntent";
    public static final Field USER = RelationalDatabaseConnectorConfig.USER.optional().withNoValidation();
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(1433);
    public static final Field INSTANCE = Field.create((String)"database.instance").withDisplayName("Instance name").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)8)).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isOptional}).withDescription("The SQL Server instance name");
    public static final Field DATABASE_NAMES = Field.create((String)"database.names").withDisplayName("Databases").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)7)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{SqlServerConnectorConfig::validateDatabaseNames}).withDescription("The names of the databases from which the connector should capture changes");
    public static final Field MAX_LSN_OPTIMIZATION = Field.createInternal((String)"streaming.lsn.optimization").withDisplayName("Max LSN Optimization").withDefault(true).withType(ConfigDef.Type.BOOLEAN).withImportance(ConfigDef.Importance.LOW).withDescription("This property can be used to enable/disable an optimization that prevents querying the cdc tables on LSNs not correlated to changes.");
    public static final Field MAX_TRANSACTIONS_PER_ITERATION = Field.create((String)"max.iteration.transactions").withDisplayName("Max transactions per iteration").withDefault(0).withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)1)).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isNonNegativeInteger}).withDescription("This property can be used to reduce the connector memory usage footprint when changes are streamed from multiple tables per database.");
    public static final Field MAX_RETRIES_ON_ERROR = Field.create((String)"errors.max.retries").withDisplayName("The maximum number of retries").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(-1).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("The maximum number of retries on connection errors before failing (-1 = no limit, 0 = disabled, > 0 = num of retries).");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Select one of the following snapshot options: 'initial' (default): If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures the current full state of the configured tables. After the snapshot completes, the connector begins to stream changes from the transaction log.; 'initial_only': The connector performs a snapshot as it does for the 'initial' option, but after the connector completes the snapshot, it stops, and does not stream changes from the transaction log.; 'schema_only': If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures only the schema (table structures), but not any table data. After the snapshot completes, the connector begins to stream changes from the transaction log.");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create((String)"snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, (Enum)SnapshotIsolationMode.REPEATABLE_READ).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the captured tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all captured tables during the entire snapshot duration. When '" + SnapshotIsolationMode.SNAPSHOT.getValue() + "' is specified, connector runs the initial snapshot in SNAPSHOT isolation level, which guarantees snapshot consistency. In addition, neither table nor row-level locks are held. When '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' is specified, connector runs the initial snapshot in READ COMMITTED isolation level. No long-running locks are taken, so that initial snapshot does not prevent other transactions from updating table rows. Snapshot consistency is not guaranteed.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    public static final Field INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE = Field.create((String)"incremental.snapshot.option.recompile").withDisplayName("Recompile SELECT statements").withDefault(false).withType(ConfigDef.Type.BOOLEAN).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Add OPTION(RECOMPILE) on each SELECT statement during the incremental snapshot process. This prevents parameter sniffing but can cause CPU pressure on the source database.");
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(SqlServerSourceInfoStructMaker.class.getName());
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("SQL Server").type(new Field[]{DATABASE_NAMES, HOSTNAME, PORT, USER, PASSWORD, INSTANCE}).connector(new Field[]{SNAPSHOT_MODE, SNAPSHOT_ISOLATION_MODE, MAX_TRANSACTIONS_PER_ITERATION, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE, INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, MAX_RETRIES_ON_ERROR}).events(new Field[]{SOURCE_INFO_STRUCT_MAKER}).excluding(new Field[]{SCHEMA_INCLUDE_LIST, SCHEMA_EXCLUDE_LIST}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final List<String> databaseNames;
    private final String instanceName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final boolean readOnlyDatabaseConnection;
    private final int maxTransactionsPerIteration;
    private final int maxRetriesOnError;
    private final boolean optionRecompile;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public SqlServerConnectorConfig(Configuration config) {
        super(SqlServerConnector.class, config, (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), true, ColumnFilterMode.SCHEMA, true);
        String databaseNames = config.getString(DATABASE_NAMES.name());
        this.databaseNames = databaseNames != null ? Arrays.asList(databaseNames.split(",")) : Collections.emptyList();
        this.instanceName = config.getString(INSTANCE);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.readOnlyDatabaseConnection = READ_ONLY_INTENT.equals(config.getString(APPLICATION_INTENT_KEY));
        if (this.readOnlyDatabaseConnection) {
            this.snapshotIsolationMode = SnapshotIsolationMode.SNAPSHOT;
            LOGGER.info("JDBC connection has set applicationIntent = ReadOnly, switching snapshot isolation mode to {}", (Object)SnapshotIsolationMode.SNAPSHOT.name());
        } else {
            this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
        }
        this.maxTransactionsPerIteration = config.getInteger(MAX_TRANSACTIONS_PER_ITERATION);
        this.maxRetriesOnError = config.getInteger(MAX_RETRIES_ON_ERROR);
        if (!config.getBoolean(MAX_LSN_OPTIMIZATION)) {
            LOGGER.warn("The option '{}' is no longer taken into account. The optimization is always enabled.", (Object)MAX_LSN_OPTIMIZATION.name());
        }
        this.optionRecompile = config.getBoolean(INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE);
    }

    public List<String> getDatabaseNames() {
        return this.databaseNames;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean useSingleDatabase() {
        return this.databaseNames.size() == 1;
    }

    public SqlServerJdbcConfiguration getJdbcConfig() {
        JdbcConfiguration config = super.getJdbcConfig();
        if (this.useSingleDatabase()) {
            config = (JdbcConfiguration)JdbcConfiguration.copy((Configuration)config).withDatabase(this.databaseNames.get(0)).build();
        }
        SqlServerJdbcConfiguration sqlServerconfig = SqlServerJdbcConfiguration.adapt((Configuration)config);
        if (this.getInstanceName() != null) {
            sqlServerconfig = (SqlServerJdbcConfiguration)SqlServerJdbcConfiguration.copy((Configuration)config).withInstance(this.getInstanceName()).build();
        }
        return sqlServerconfig;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public boolean isReadOnlyDatabaseConnection() {
        return this.readOnlyDatabaseConnection;
    }

    public int getMaxTransactionsPerIteration() {
        return this.maxTransactionsPerIteration;
    }

    public int getMaxRetriesOnError() {
        return this.maxRetriesOnError;
    }

    public boolean getOptionRecompile() {
        return this.optionRecompile;
    }

    public boolean supportsOperationFiltering() {
        return true;
    }

    protected boolean supportsSchemaChangesDuringIncrementalSnapshot() {
        return true;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.valueOf(recorded.getString((CharSequence)"change_lsn")).compareTo(Lsn.valueOf(desired.getString((CharSequence)"change_lsn"))) < 1;
            }
        };
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    public Map<TableId, String> getSnapshotSelectOverridesByTable() {
        List tableValues = this.getConfig().getTrimmedStrings(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, ",");
        if (tableValues == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableValues) {
            snapshotSelectOverridesByTable.put(TableId.parse((String)table, (TableIdPredicates)new SqlServerTableIdPredicates()), this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table));
        }
        return Collections.unmodifiableMap(snapshotSelectOverridesByTable);
    }

    private static int validateDatabaseNames(Configuration config, Field field, Field.ValidationOutput problems) {
        String databaseNames = config.getString(field);
        int count = 0;
        if (Strings.isNullOrBlank((String)databaseNames)) {
            problems.accept(field, (Object)databaseNames, "Cannot be empty");
            ++count;
        }
        return count;
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return t.schema() != null && !t.schema().toLowerCase().equals("cdc") && !t.schema().toLowerCase().equals("sys") && !t.table().toLowerCase().equals("systranschemas");
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        INITIAL_ONLY("initial_only", true),
        SCHEMA_ONLY("schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        SNAPSHOT("snapshot"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

