/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot.lock;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.snapshot.spi.SnapshotLock;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SharedSnapshotLock
implements SnapshotLock {
    public String name() {
        return PostgresConnectorConfig.SnapshotLockingMode.SHARED.getValue();
    }

    public void configure(Map<String, ?> properties) {
    }

    public Optional<String> tableLockingStatement(Duration lockTimeout, Set<String> tableIds) {
        String lineSeparator = System.lineSeparator();
        StringBuilder statements = new StringBuilder();
        statements.append("SET lock_timeout = ").append(lockTimeout.toMillis()).append(";").append(lineSeparator);
        tableIds.forEach(tableId -> statements.append("LOCK TABLE ").append((String)tableId).append(" IN ACCESS SHARE MODE;").append(lineSeparator));
        return Optional.of(statements.toString());
    }
}

