/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.MessageDecoder;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import io.debezium.connector.postgresql.connection.WalPositionLocator;
import io.debezium.util.Clock;
import io.debezium.util.Threads;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageDecoder.class);
    private static final Duration LOG_INTERVAL_DURATION = Duration.ofSeconds(10L);
    private Threads.Timer timer = null;

    @Override
    public void processMessage(ByteBuffer buffer, ReplicationStream.ReplicationMessageProcessor processor, TypeRegistry typeRegistry) throws SQLException, InterruptedException {
        if (buffer == null) {
            processor.process(null);
        } else {
            this.processNotEmptyMessage(buffer, processor, typeRegistry);
        }
    }

    protected abstract void processNotEmptyMessage(ByteBuffer var1, ReplicationStream.ReplicationMessageProcessor var2, TypeRegistry var3) throws SQLException, InterruptedException;

    @Override
    public boolean shouldMessageBeSkipped(ByteBuffer buffer, Lsn lastReceivedLsn, Lsn startLsn, WalPositionLocator walPosition) {
        if (walPosition.skipMessage(lastReceivedLsn)) {
            if (this.timerPermitsLogging()) {
                LOGGER.info("Streaming requested from LSN {}, received LSN {} identified as already processed", (Object)startLsn, (Object)lastReceivedLsn);
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    private boolean timerPermitsLogging() {
        if (this.timer == null || this.timer.expired()) {
            this.timer = Threads.timer((Clock)Clock.SYSTEM, (Duration)LOG_INTERVAL_DURATION);
            return true;
        }
        return false;
    }
}

