/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.spi;

import io.debezium.common.annotation.Incubating;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.spi.OffsetState;
import io.debezium.connector.postgresql.spi.SlotCreationResult;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.relational.TableId;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

@Incubating
public interface Snapshotter {
    public void init(PostgresConnectorConfig var1, OffsetState var2, SlotState var3);

    public boolean shouldSnapshot();

    public boolean shouldStream();

    default public boolean shouldStreamEventsStartingFromSnapshot() {
        return true;
    }

    default public boolean exportSnapshot() {
        return false;
    }

    public Optional<String> buildSnapshotQuery(TableId var1);

    default public String snapshotTransactionIsolationLevelStatement(SlotCreationResult newSlotInfo) {
        return "SET TRANSACTION ISOLATION LEVEL SERIALIZABLE, READ ONLY, DEFERRABLE;";
    }

    default public Optional<String> snapshotTableLockingStatement(Duration lockTimeout, Set<TableId> tableIds) {
        String lineSeparator = System.lineSeparator();
        StringBuilder statements = new StringBuilder();
        statements.append("SET lock_timeout = ").append(lockTimeout.toMillis()).append(";").append(lineSeparator);
        tableIds.forEach(tableId -> statements.append("LOCK TABLE ").append(tableId.toDoubleQuotedString()).append(" IN ACCESS SHARE MODE;").append(lineSeparator));
        return Optional.of(statements.toString());
    }

    default public void snapshotCompleted() {
    }
}

