/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgoutput;

import io.debezium.annotation.Immutable;
import io.debezium.connector.postgresql.PostgresType;

@Immutable
public class ColumnMetaData {
    private final String columnName;
    private final PostgresType postgresType;
    private final boolean key;
    private final boolean optional;
    private final int length;
    private final int scale;
    private final String typeName;

    ColumnMetaData(String columnName, PostgresType postgresType, boolean key, boolean optional, int typeModifier) {
        this.columnName = columnName;
        this.postgresType = postgresType;
        this.key = key;
        this.optional = optional;
        if (-1 != typeModifier && postgresType.getTypeInfo() != null) {
            this.length = postgresType.getTypeInfo().getPrecision(postgresType.getOid(), typeModifier);
            this.scale = postgresType.getTypeInfo().getScale(postgresType.getOid(), typeModifier);
        } else {
            this.length = postgresType.getDefaultLength();
            this.scale = postgresType.getDefaultScale();
        }
        Object type = postgresType.getName();
        if (this.length != postgresType.getDefaultLength() || this.scale != 0) {
            type = (String)type + "(" + this.length + "," + this.scale + ")";
        }
        this.typeName = type;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public PostgresType getPostgresType() {
        return this.postgresType;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getLength() {
        return this.length;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

