/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgoutput;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.ReplicationMessageColumnValueResolver;
import io.debezium.connector.postgresql.connection.pgoutput.PgOutputColumnValue;
import java.time.Instant;
import java.util.List;

public class PgOutputReplicationMessage
implements ReplicationMessage {
    private ReplicationMessage.Operation op;
    private Instant commitTimestamp;
    private long transactionId;
    private String table;
    private List<ReplicationMessage.Column> oldColumns;
    private List<ReplicationMessage.Column> newColumns;

    public PgOutputReplicationMessage(ReplicationMessage.Operation op, String table, Instant commitTimestamp, long transactionId, List<ReplicationMessage.Column> oldColumns, List<ReplicationMessage.Column> newColumns) {
        this.op = op;
        this.commitTimestamp = commitTimestamp;
        this.transactionId = transactionId;
        this.table = table;
        this.oldColumns = oldColumns;
        this.newColumns = newColumns;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        return this.op;
    }

    @Override
    public Instant getCommitTime() {
        return this.commitTimestamp;
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        return this.oldColumns;
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.newColumns;
    }

    @Override
    public boolean hasTypeMetadata() {
        return true;
    }

    @Override
    public boolean isLastEventForLsn() {
        return true;
    }

    @Override
    public boolean shouldSchemaBeSynchronized() {
        return false;
    }

    public static Object getValue(String columnName, PostgresType type, String fullType, String rawValue, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDataTypes, TypeRegistry typeRegistry) {
        PgOutputColumnValue columnValue = new PgOutputColumnValue(rawValue);
        return ReplicationMessageColumnValueResolver.resolveValue(columnName, type, fullType, columnValue, connection, includeUnknownDataTypes, typeRegistry);
    }
}

