/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import java.util.Objects;
import org.postgresql.core.TypeInfo;

public class PostgresType {
    public static final PostgresType UNKNOWN = new PostgresType("unknown", -1, Integer.MIN_VALUE, null);
    private final String name;
    private final int oid;
    private final int jdbcId;
    private final PostgresType elementType;
    private final TypeInfo typeInfo;

    public PostgresType(String name, int oid, int jdbcId, TypeInfo typeInfo) {
        this(name, oid, jdbcId, typeInfo, null);
    }

    public PostgresType(String name, int oid, int jdbcId, TypeInfo typeInfo, PostgresType elementType) {
        Objects.requireNonNull(name);
        this.name = name;
        this.oid = oid;
        this.jdbcId = jdbcId;
        this.elementType = elementType;
        this.typeInfo = typeInfo;
    }

    public boolean isArrayType() {
        return this.elementType != null;
    }

    public String getName() {
        return this.name;
    }

    public int getOid() {
        return this.oid;
    }

    public int getJdbcId() {
        return this.jdbcId;
    }

    public PostgresType getElementType() {
        return this.elementType;
    }

    public int getDefaultLength() {
        if (this.typeInfo == null) {
            return -1;
        }
        int size = this.typeInfo.getPrecision(this.oid, -1);
        if (size == 0) {
            size = this.typeInfo.getDisplaySize(this.oid, -1);
        }
        return size;
    }

    public int getDefaultScale() {
        if (this.typeInfo == null) {
            return -1;
        }
        return this.typeInfo.getScale(this.oid, -1);
    }

    public int length(int modifier) {
        if (this.typeInfo == null) {
            return -1;
        }
        switch (this.oid) {
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.typeInfo.getPrecision(this.oid, modifier);
            }
        }
        return modifier;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public int scale(int modifier) {
        if (this.typeInfo == null) {
            return -1;
        }
        switch (this.oid) {
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.typeInfo.getScale(this.oid, modifier);
            }
        }
        return this.getDefaultScale();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.oid;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PostgresType other = (PostgresType)obj;
        return this.oid == other.oid;
    }

    public String toString() {
        return "PostgresType [name=" + this.name + ", oid=" + this.oid + ", jdbcId=" + this.jdbcId + ", defaultLength=" + this.getDefaultLength() + ", defaultScale=" + this.getDefaultScale() + ", elementType=" + this.elementType + "]";
    }
}

