/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.wal2json;

import io.debezium.connector.postgresql.connection.AbstractColumnValue;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.document.Value;
import io.debezium.util.Strings;
import java.math.BigDecimal;

class Wal2JsonColumnValue
extends AbstractColumnValue<Value> {
    private Value value;

    Wal2JsonColumnValue(Value value) {
        this.value = value;
    }

    @Override
    public Value getRawValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public String asString() {
        return this.value.asString();
    }

    @Override
    public Boolean asBoolean() {
        return this.value.asBoolean();
    }

    @Override
    public Integer asInteger() {
        return this.value.asInteger();
    }

    @Override
    public Long asLong() {
        return this.value.asLong();
    }

    @Override
    public Float asFloat() {
        return this.value.isNumber() ? this.value.asFloat() : Float.valueOf(this.value.asString());
    }

    @Override
    public Double asDouble() {
        return this.value.isNumber() ? this.value.asDouble() : Double.valueOf(this.value.asString());
    }

    @Override
    public SpecialValueDecimal asDecimal() {
        if (this.value.isInteger()) {
            return new SpecialValueDecimal(new BigDecimal(this.value.asInteger()));
        }
        if (this.value.isLong()) {
            return new SpecialValueDecimal(new BigDecimal(this.value.asLong()));
        }
        if (this.value.isBigInteger()) {
            return new SpecialValueDecimal(new BigDecimal(this.value.asBigInteger()));
        }
        return SpecialValueDecimal.valueOf((String)this.value.asString());
    }

    @Override
    public byte[] asByteArray() {
        return Strings.hexStringToByteArray((String)this.value.asString());
    }
}

