/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.relational.TableId;

public interface TopicSelector {
    public static TopicSelector create(PostgresConnectorConfig config) {
        PostgresConnectorConfig.TopicSelectionStrategy topicSelectionStrategy = config.topicSelectionStrategy();
        switch (topicSelectionStrategy) {
            case TOPIC_PER_SCHEMA: {
                return TopicSelector.topicPerSchema(config.serverName());
            }
            case TOPIC_PER_TABLE: {
                return TopicSelector.topicPerTable(config.serverName());
            }
        }
        throw new IllegalArgumentException("Unknown topic selection strategy: " + (Object)((Object)topicSelectionStrategy));
    }

    public static TopicSelector topicPerTable(String prefix) {
        return tableId -> String.join((CharSequence)".", prefix, tableId.schema(), tableId.table());
    }

    public static TopicSelector topicPerSchema(String prefix) {
        return tableId -> String.join((CharSequence)".", prefix, tableId.schema());
    }

    public String topicNameFor(TableId var1);
}

