/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.wal2json;

import io.debezium.time.NanoTimestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.function.Supplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DateTimeFormat {
    public long timestamp(String var1);

    public long timestampWithTimeZone(String var1);

    public long systemTimestamp(String var1);

    public LocalDate date(String var1);

    public LocalTime time(String var1);

    public OffsetTime timeWithTimeZone(String var1);

    public static DateTimeFormat get() {
        return new ISODateTimeFormat();
    }

    public static class ISODateTimeFormat
    implements DateTimeFormat {
        private static final Logger LOGGER = LoggerFactory.getLogger(ISODateTimeFormat.class);
        private static final String TS_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
        private static final DateTimeFormatter TS_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final String TS_TZ_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss[.S]X";
        private static final DateTimeFormatter TS_TZ_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).appendOffset("+HH", "").toFormatter();
        private static final String SYSTEM_TS_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSSSSX";
        private static final DateTimeFormatter SYSTEM_TS_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).appendOffset("+HH", "Z").toFormatter();
        private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
        private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private static final String TIME_FORMAT_PATTERN = "HH:mm:ss";
        private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
        private static final String TIME_TZ_FORMAT_PATTERN = "HH:mm:ssX";
        private static final DateTimeFormatter TIME_TZ_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ssX");

        @Override
        public long timestamp(String s) {
            return this.format(TS_FORMAT_PATTERN, s, () -> NanoTimestamp.toEpochNanos((Object)LocalDateTime.parse(s, TS_FORMAT), null));
        }

        @Override
        public long timestampWithTimeZone(String s) {
            return this.formatTZ(TS_TZ_FORMAT_PATTERN, TS_TZ_FORMAT, s);
        }

        @Override
        public LocalDate date(String s) {
            return this.format(DATE_FORMAT_PATTERN, s, () -> LocalDate.parse(s, DATE_FORMAT));
        }

        @Override
        public LocalTime time(String s) {
            return this.format(TIME_FORMAT_PATTERN, s, () -> LocalTime.parse(s, TIME_FORMAT));
        }

        @Override
        public OffsetTime timeWithTimeZone(String s) {
            return this.format(TIME_TZ_FORMAT_PATTERN, s, () -> OffsetTime.parse(s, TIME_TZ_FORMAT)).withOffsetSameInstant(ZoneOffset.UTC);
        }

        @Override
        public long systemTimestamp(String s) {
            return this.formatTZ(SYSTEM_TS_FORMAT_PATTERN, SYSTEM_TS_FORMAT, s);
        }

        private long formatTZ(String pattern, DateTimeFormatter formatter, String s) {
            return this.format(pattern, s, () -> {
                Instant ts = Instant.from(formatter.parse(s));
                return ts.getEpochSecond() * 1000000000L + (long)ts.getNano();
            });
        }

        private <T> T format(String pattern, String s, Supplier<T> value) {
            try {
                return value.get();
            }
            catch (DateTimeParseException e) {
                LOGGER.error("Cannot parse time/date value '{}', expected format '{}'", (Object)s, (Object)pattern);
                throw new ConnectException((Throwable)e);
            }
        }
    }
}

