/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgproto;

import io.debezium.connector.postgresql.RecordsStreamProducer;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.postgresql.core.BaseConnection;
import org.postgresql.geometric.PGpoint;
import org.postgresql.jdbc.PgArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PgProtoReplicationMessage
implements ReplicationMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgProtoReplicationMessage.class);
    private final PgProto.RowMessage rawMessage;

    public PgProtoReplicationMessage(PgProto.RowMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        switch (this.rawMessage.getOp()) {
            case INSERT: {
                return ReplicationMessage.Operation.INSERT;
            }
            case UPDATE: {
                return ReplicationMessage.Operation.UPDATE;
            }
            case DELETE: {
                return ReplicationMessage.Operation.DELETE;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + (Object)((Object)this.rawMessage.getOp()) + "' in replication stream message");
    }

    @Override
    public long getCommitTime() {
        return this.rawMessage.getCommitTime();
    }

    @Override
    public int getTransactionId() {
        return this.rawMessage.getTransactionId();
    }

    @Override
    public String getTable() {
        return this.rawMessage.getTable();
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        return this.transform(this.rawMessage.getOldTupleList(), null);
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.transform(this.rawMessage.getNewTupleList(), this.rawMessage.getNewTypeinfoList());
    }

    @Override
    public boolean hasMetadata() {
        return this.rawMessage.getNewTypeinfoList() != null && !this.rawMessage.getNewTypeinfoList().isEmpty();
    }

    private List<ReplicationMessage.Column> transform(List<PgProto.DatumMessage> messageList, List<PgProto.TypeInfo> typeInfoList) {
        return IntStream.range(0, messageList.size()).mapToObj(index -> {
            final PgProto.DatumMessage datum = (PgProto.DatumMessage)messageList.get(index);
            Optional<Object> typeInfo = Optional.ofNullable(this.hasMetadata() && typeInfoList != null ? (PgProto.TypeInfo)typeInfoList.get(index) : null);
            String columnName = Strings.unquoteIdentifierPart((String)datum.getColumnName());
            return new AbstractReplicationMessageColumn(columnName, typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null), typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE), this.hasMetadata()){

                @Override
                public Object getValue(RecordsStreamProducer.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                    return PgProtoReplicationMessage.this.getValue(datum, connection, includeUnknownDatatypes);
                }

                @Override
                public int doGetOidType() {
                    return (int)datum.getColumnType();
                }
            };
        }).collect(Collectors.toList());
    }

    public Object getValue(PgProto.DatumMessage datumMessage, RecordsStreamProducer.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        int columnType = (int)datumMessage.getColumnType();
        switch (columnType) {
            case 16: {
                return datumMessage.hasDatumBool() ? Boolean.valueOf(datumMessage.getDatumBool()) : null;
            }
            case 21: 
            case 23: {
                return datumMessage.hasDatumInt32() ? Integer.valueOf(datumMessage.getDatumInt32()) : null;
            }
            case 20: 
            case 26: 
            case 790: {
                return datumMessage.hasDatumInt64() ? Long.valueOf(datumMessage.getDatumInt64()) : null;
            }
            case 700: {
                return datumMessage.hasDatumFloat() ? Float.valueOf(datumMessage.getDatumFloat()) : null;
            }
            case 701: 
            case 1700: {
                return datumMessage.hasDatumDouble() ? Double.valueOf(datumMessage.getDatumDouble()) : null;
            }
            case 18: 
            case 25: 
            case 114: 
            case 142: 
            case 1042: 
            case 1043: 
            case 1560: 
            case 1562: 
            case 2950: 
            case 3802: {
                return datumMessage.hasDatumString() ? datumMessage.getDatumString() : null;
            }
            case 1082: {
                return datumMessage.hasDatumInt32() ? Long.valueOf(datumMessage.getDatumInt32()) : null;
            }
            case 1083: 
            case 1114: 
            case 1184: {
                if (!datumMessage.hasDatumInt64()) {
                    return null;
                }
                return TimeUnit.NANOSECONDS.convert(datumMessage.getDatumInt64(), TimeUnit.MICROSECONDS);
            }
            case 1266: {
                if (!datumMessage.hasDatumDouble()) {
                    return null;
                }
                return BigDecimal.valueOf(datumMessage.getDatumDouble() * 1000.0).longValue();
            }
            case 1186: {
                return datumMessage.hasDatumDouble() ? Double.valueOf(datumMessage.getDatumDouble()) : null;
            }
            case 17: {
                return datumMessage.hasDatumBytes() ? datumMessage.getDatumBytes().toByteArray() : null;
            }
            case 600: {
                PgProto.Point datumPoint = datumMessage.getDatumPoint();
                return new PGpoint(datumPoint.getX(), datumPoint.getY());
            }
            case 3910: {
                return datumMessage.hasDatumBytes() ? new String(datumMessage.getDatumBytes().toByteArray(), Charset.forName("UTF-8")) : null;
            }
            case 143: 
            case 199: 
            case 791: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: 
            case 1007: 
            case 1009: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1021: 
            case 1022: 
            case 1028: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1185: 
            case 1187: 
            case 1231: 
            case 1270: 
            case 1563: 
            case 2201: 
            case 2951: 
            case 3807: {
                try {
                    byte[] data;
                    byte[] byArray = data = datumMessage.hasDatumBytes() ? datumMessage.getDatumBytes().toByteArray() : null;
                    if (data == null) {
                        return null;
                    }
                    String dataString = new String(data, Charset.forName("UTF-8"));
                    PgArray arrayData = new PgArray((BaseConnection)connection.get(), columnType, dataString);
                    Object deserializedArray = arrayData.getArray();
                    return Arrays.asList((Object[])deserializedArray);
                }
                catch (SQLException e) {
                    LOGGER.warn("Unexpected exception trying to process PgArray column '{}'", (Object)datumMessage.getColumnName(), (Object)e);
                    return null;
                }
            }
        }
        if (includeUnknownDatatypes && datumMessage.hasDatumBytes()) {
            return datumMessage.getDatumBytes().toByteArray();
        }
        return null;
    }
}

