/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.wal2json;

import io.debezium.connector.postgresql.PgOid;
import io.debezium.connector.postgresql.RecordsStreamProducer;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.wal2json.DateTimeFormat;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.Value;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.core.BaseConnection;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.jdbc.PgArray;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Wal2JsonReplicationMessage
implements ReplicationMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(Wal2JsonReplicationMessage.class);
    private final int txId;
    private final long commitTime;
    private final Document rawMessage;
    private final boolean hasMetadata;

    public Wal2JsonReplicationMessage(int txId, long commitTime, Document rawMessage, boolean hasMetadata) {
        this.txId = txId;
        this.commitTime = commitTime;
        this.rawMessage = rawMessage;
        this.hasMetadata = hasMetadata;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        String operation;
        switch (operation = this.rawMessage.getString((CharSequence)"kind")) {
            case "insert": {
                return ReplicationMessage.Operation.INSERT;
            }
            case "update": {
                return ReplicationMessage.Operation.UPDATE;
            }
            case "delete": {
                return ReplicationMessage.Operation.DELETE;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + operation + "' in replication stream message");
    }

    @Override
    public long getCommitTime() {
        return this.commitTime;
    }

    @Override
    public int getTransactionId() {
        return this.txId;
    }

    @Override
    public String getTable() {
        return "\"" + this.rawMessage.getString((CharSequence)"schema") + "\".\"" + this.rawMessage.getString((CharSequence)"table") + "\"";
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        Document oldkeys = this.rawMessage.getDocument((CharSequence)"oldkeys");
        return oldkeys != null ? this.transform(oldkeys, "keynames", "keytypes", "keyvalues", "columnoptionals") : null;
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.transform(this.rawMessage, "columnnames", "columntypes", "columnvalues", "columnoptionals");
    }

    @Override
    public boolean hasMetadata() {
        return this.hasMetadata;
    }

    private List<ReplicationMessage.Column> transform(Document data, String nameField, String typeField, String valueField, String optionalsField) {
        Array columnNames = data.getArray((CharSequence)nameField);
        Array columnTypes = data.getArray((CharSequence)typeField);
        Array columnValues = data.getArray((CharSequence)valueField);
        Array columnOptionals = data.getArray((CharSequence)optionalsField);
        if (columnNames.size() != columnTypes.size() || columnNames.size() != columnValues.size()) {
            throw new ConnectException("Column related arrays do not have the same size");
        }
        ArrayList<ReplicationMessage.Column> columns = new ArrayList<ReplicationMessage.Column>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            final String columnName = columnNames.get(i).asString();
            String columnType = columnTypes.get(i).asString();
            boolean columnOptional = columnOptionals != null ? columnOptionals.get(i).asBoolean() : false;
            final Value rawValue = columnValues.get(i);
            columns.add(new AbstractReplicationMessageColumn(columnName, columnType, columnOptional, true){

                @Override
                public Object getValue(RecordsStreamProducer.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                    return Wal2JsonReplicationMessage.this.getValue(columnName, this.getTypeMetadata(), rawValue, connection, includeUnknownDatatypes);
                }

                @Override
                public int doGetOidType() {
                    return this.getTypeMetadata().isArray() ? PgOid.typeNameToOid(this.getTypeMetadata().getName().substring(1)) : PgOid.typeNameToOid(this.getTypeMetadata().getName());
                }
            });
        }
        return columns;
    }

    public Object getValue(String columnName, AbstractReplicationMessageColumn.TypeMetadataImpl typeMetadata, Value rawValue, RecordsStreamProducer.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        if (rawValue.isNull()) {
            return null;
        }
        if (typeMetadata.isArray()) {
            try {
                String dataString = rawValue.asString();
                PgArray arrayData = new PgArray((BaseConnection)connection.get(), connection.get().getTypeInfo().getPGArrayType(typeMetadata.getFullType()), dataString);
                Object deserializedArray = arrayData.getArray();
                return Arrays.asList((Object[])deserializedArray);
            }
            catch (SQLException e) {
                LOGGER.warn("Unexpected exception trying to process PgArray ({}) column '{}', {}", new Object[]{typeMetadata.getFullType(), columnName, e});
                return null;
            }
        }
        switch (typeMetadata.getBaseType()) {
            case "boolean": 
            case "bool": {
                return rawValue.asBoolean();
            }
            case "integer": 
            case "int": 
            case "int4": 
            case "smallint": 
            case "int2": 
            case "smallserial": 
            case "serial": 
            case "serial2": 
            case "serial4": 
            case "oid": {
                return rawValue.asInteger();
            }
            case "bigint": 
            case "bigserial": 
            case "int8": {
                return rawValue.asLong();
            }
            case "real": 
            case "float4": {
                return rawValue.asFloat();
            }
            case "double precision": 
            case "float8": {
                return rawValue.asDouble();
            }
            case "numeric": 
            case "decimal": {
                return rawValue.asDouble();
            }
            case "character": 
            case "char": 
            case "character varying": 
            case "varchar": 
            case "bpchar": 
            case "text": {
                return rawValue.asString();
            }
            case "date": {
                return DateTimeFormat.get().date(rawValue.asString());
            }
            case "timestamp with time zone": 
            case "timestamptz": {
                return DateTimeFormat.get().timestampWithTimeZone(rawValue.asString());
            }
            case "timestamp": 
            case "timestamp without time zone": {
                return DateTimeFormat.get().timestamp(rawValue.asString());
            }
            case "time": 
            case "time without time zone": {
                return DateTimeFormat.get().time(rawValue.asString());
            }
            case "time with time zone": 
            case "timetz": {
                return DateTimeFormat.get().timeWithTimeZone(rawValue.asString());
            }
            case "bytea": {
                return Strings.hexStringToByteArray((String)rawValue.asString());
            }
            case "box": {
                try {
                    return new PGbox(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "circle": {
                try {
                    return new PGcircle(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse circle {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "interval": {
                try {
                    return new PGInterval(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "line": {
                try {
                    return new PGline(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "lseg": {
                try {
                    return new PGlseg(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "money": {
                try {
                    return new PGmoney((String)rawValue.asString()).val;
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse money {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "path": {
                try {
                    return new PGpath(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "point": {
                try {
                    return new PGpoint(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "polygon": {
                try {
                    return new PGpolygon(rawValue.asString());
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to parse point {}, {}", (Object)rawValue.asString(), (Object)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            case "bit": 
            case "bit varying": 
            case "varbit": 
            case "json": 
            case "jsonb": 
            case "xml": 
            case "uuid": 
            case "tstzrange": {
                return rawValue.asString();
            }
        }
        if (includeUnknownDatatypes) {
            LOGGER.debug("processing column '{}' with unknown data type '{}' as byte array", (Object)columnName, (Object)typeMetadata.getFullType());
            return rawValue.asString();
        }
        return null;
    }
}

