/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PgOid;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.data.Bits;
import io.debezium.data.Json;
import io.debezium.data.Uuid;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.data.geometry.Point;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.Date;
import io.debezium.time.MicroDuration;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGobject;

public class PostgresValueConverter
extends JdbcValueConverters {
    protected static final double DAYS_PER_MONTH_AVG = 30.4375;
    private static final int VARIABLE_SCALE_DECIMAL_LENGTH = 131089;

    protected PostgresValueConverter(JdbcValueConverters.DecimalMode decimalMode, boolean adaptiveTimePrecision, ZoneOffset defaultOffset, JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode) {
        super(decimalMode, adaptiveTimePrecision, defaultOffset, null, bigIntUnsignedMode);
    }

    public SchemaBuilder schemaBuilder(Column column) {
        int oidValue = PgOid.jdbcColumnToOid(column);
        switch (oidValue) {
            case 1560: 
            case 1561: 
            case 1562: {
                return column.length() > 1 ? Bits.builder((int)column.length()) : SchemaBuilder.bool();
            }
            case 1186: {
                return MicroDuration.builder();
            }
            case 1184: {
                return ZonedTimestamp.builder();
            }
            case 1266: {
                return ZonedTime.builder();
            }
            case 26: {
                return SchemaBuilder.int64();
            }
            case 114: 
            case 1111: {
                return Json.builder();
            }
            case 3910: {
                return SchemaBuilder.string();
            }
            case 2950: {
                return Uuid.builder();
            }
            case 600: {
                return Point.builder();
            }
            case 790: {
                return Decimal.builder((int)column.scale());
            }
            case 1700: {
                return this.numericSchema(column).optional();
            }
            case 1005: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_INT16_SCHEMA);
            }
            case 1007: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_INT32_SCHEMA);
            }
            case 1016: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_INT64_SCHEMA);
            }
            case 1009: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
            }
            case 1231: {
                return SchemaBuilder.array((Schema)this.numericSchema(column).optional());
            }
            case 1021: {
                return SchemaBuilder.array((Schema)Schema.OPTIONAL_FLOAT32_SCHEMA);
            }
            case 1022: {
                return SchemaBuilder.array((Schema)Schema.OPTIONAL_FLOAT64_SCHEMA);
            }
            case 1000: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_BOOLEAN_SCHEMA);
            }
            case 1182: {
                if (this.adaptiveTimePrecision) {
                    return SchemaBuilder.array((Schema)Date.builder().optional().build());
                }
                return SchemaBuilder.array((Schema)org.apache.kafka.connect.data.Date.builder().optional().build());
            }
            case 143: 
            case 199: 
            case 791: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1014: 
            case 1015: 
            case 1017: 
            case 1028: 
            case 1115: 
            case 1183: 
            case 1185: 
            case 1187: 
            case 1270: 
            case 1563: 
            case 2201: 
            case 2951: 
            case 3807: {
                return null;
            }
        }
        return super.schemaBuilder(column);
    }

    private SchemaBuilder numericSchema(Column column) {
        switch (this.decimalMode) {
            case DOUBLE: {
                return SchemaBuilder.float64();
            }
            case PRECISE: {
                return this.isVariableScaleDecimal(column) ? VariableScaleDecimal.builder() : Decimal.builder((int)column.scale());
            }
        }
        throw new IllegalArgumentException("Unknown decimalMode");
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        int oidValue = PgOid.jdbcColumnToOid(column);
        switch (oidValue) {
            case 1560: 
            case 1562: {
                return this.convertBits(column, fieldDefn);
            }
            case 1186: {
                return data -> this.convertInterval(column, fieldDefn, data);
            }
            case 1184: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case 1266: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 26: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 114: 
            case 1111: 
            case 2950: 
            case 3910: {
                return data -> super.convertString(column, fieldDefn, data);
            }
            case 600: {
                return data -> this.convertPoint(column, fieldDefn, data);
            }
            case 790: {
                return data -> this.convertMoney(column, fieldDefn, data);
            }
            case 1700: {
                switch (this.decimalMode) {
                    case DOUBLE: {
                        return data -> this.convertDouble(column, fieldDefn, data);
                    }
                    case PRECISE: {
                        return data -> this.convertDecimal(column, fieldDefn, data);
                    }
                }
            }
            case 143: 
            case 199: 
            case 791: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: 
            case 1007: 
            case 1009: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1021: 
            case 1022: 
            case 1028: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1185: 
            case 1187: 
            case 1231: 
            case 1270: 
            case 1563: 
            case 2201: 
            case 2951: 
            case 3807: {
                return data -> this.convertArray(column, fieldDefn, data);
            }
        }
        return super.converter(column, fieldDefn);
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        BigDecimal newDecimal = (BigDecimal)super.convertDecimal(column, fieldDefn, data);
        if (newDecimal == null) {
            return newDecimal;
        }
        if (column.scale() > newDecimal.scale()) {
            newDecimal = newDecimal.setScale(column.scale());
        }
        if (this.isVariableScaleDecimal(column)) {
            return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (BigDecimal)newDecimal);
        }
        return newDecimal;
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = Integer.valueOf((String)data, 2);
        }
        return super.convertBit(column, fieldDefn, data);
    }

    protected Object convertBits(Column column, Field fieldDefn, Object data, int numBytes) {
        if (data instanceof PGobject) {
            data = ((PGobject)data).getValue();
        }
        if (data instanceof String) {
            long longValue = Long.parseLong((String)data, 2);
            data = -32768L <= longValue && longValue <= 32767L ? (Number)((short)longValue) : (Number)(Integer.MIN_VALUE <= longValue && longValue <= Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue);
        }
        return super.convertBits(column, fieldDefn, data, numBytes);
    }

    protected Object convertMoney(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        if (data instanceof Double) {
            return BigDecimal.valueOf((Double)data);
        }
        if (data instanceof Number) {
            return BigDecimal.valueOf(((Number)data).longValue(), 2);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertInterval(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return Duration.ofMillis(0L);
        }
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        if (data instanceof PGInterval) {
            PGInterval interval = (PGInterval)data;
            return MicroDuration.durationMicros((int)interval.getYears(), (int)interval.getMonths(), (int)interval.getDays(), (int)interval.getHours(), (int)interval.getMinutes(), (double)interval.getSeconds(), (Double)30.4375);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochMillis(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochMicros(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochNanos(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochMillisAsDate(column, fieldDefn, data);
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            LocalDateTime localDateTime = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
            data = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        } else if (data instanceof java.util.Date) {
            data = OffsetDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)data).getTime()), ZoneOffset.UTC);
        }
        return super.convertTimestampWithZone(column, fieldDefn, data);
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            LocalTime localTime = LocalTime.ofNanoOfDay((Long)data);
            data = OffsetTime.of(localTime, ZoneOffset.UTC);
        } else if (data instanceof java.util.Date) {
            data = OffsetTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)data).getTime()), ZoneOffset.UTC);
        }
        return super.convertTimeWithZone(column, fieldDefn, data);
    }

    private static LocalDateTime nanosToLocalDateTimeUTC(long epocNanos) {
        BigInteger epochMicrosBigInt = BigInteger.valueOf(epocNanos);
        BigInteger[] secondsAndNanos = epochMicrosBigInt.divideAndRemainder(BigInteger.valueOf(TimeUnit.SECONDS.toNanos(1L)));
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(secondsAndNanos[0].longValue(), secondsAndNanos[1].longValue()), ZoneOffset.UTC);
    }

    protected Object convertPoint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        Schema schema = fieldDefn.schema();
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return Point.createValue((Schema)schema, (double)0.0, (double)0.0);
        }
        if (data instanceof PGpoint) {
            PGpoint pgPoint = (PGpoint)data;
            return Point.createValue((Schema)schema, (double)pgPoint.x, (double)pgPoint.y);
        }
        if (data instanceof String) {
            String dataString = data.toString();
            try {
                PGpoint pgPoint = new PGpoint(dataString);
                return Point.createValue((Schema)schema, (double)pgPoint.x, (double)pgPoint.y);
            }
            catch (SQLException e) {
                this.logger.warn("Error converting the string '{}' to a PGPoint type for the column '{}'", (Object)dataString, (Object)column);
            }
        }
        if (data instanceof PgProto.Point) {
            return Point.createValue((Schema)schema, (double)((PgProto.Point)data).getX(), (double)((PgProto.Point)data).getY());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertArray(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (!(data instanceof List)) {
            return this.handleUnknownData(column, fieldDefn, data);
        }
        return data;
    }

    private boolean isVariableScaleDecimal(Column column) {
        return column.scale() == 0 && column.length() == 131089;
    }
}

