/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.engine.spi;

import io.debezium.common.annotation.Incubating;
import java.time.Duration;
import java.util.Properties;

@FunctionalInterface
@Incubating
public interface OffsetCommitPolicy {
    public static OffsetCommitPolicy always() {
        return new AlwaysCommitOffsetPolicy();
    }

    public static OffsetCommitPolicy periodic(Properties config) {
        return new PeriodicCommitOffsetPolicy(config);
    }

    public boolean performCommit(long var1, Duration var3);

    default public OffsetCommitPolicy or(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) || other.performCommit(number, time);
    }

    default public OffsetCommitPolicy and(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) && other.performCommit(number, time);
    }

    public static class PeriodicCommitOffsetPolicy
    implements OffsetCommitPolicy {
        private final Duration minimumTime;

        public PeriodicCommitOffsetPolicy(Properties config) {
            this.minimumTime = Duration.ofMillis(Long.valueOf(config.getProperty("offset.flush.interval.ms")));
        }

        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return timeSinceLastCommit.compareTo(this.minimumTime) >= 0;
        }
    }

    public static class AlwaysCommitOffsetPolicy
    implements OffsetCommitPolicy {
        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return true;
        }
    }
}

