/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.LineageCollector;
import io.cucumber.query.NamingStrategy;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class NamingCollector
implements LineageCollector<String> {
    private final Deque<String> parts = new ArrayDeque<String>();
    private final CharSequence delimiter = " - ";
    private final NamingStrategy.Strategy strategy;
    private final NamingStrategy.FeatureName featureName;
    private final NamingStrategy.ExampleName exampleName;
    private String scenarioName;
    private boolean isExample;
    private int examplesIndex;

    static Supplier<NamingCollector> of(NamingStrategy.Strategy strategy, NamingStrategy.FeatureName featureName, NamingStrategy.ExampleName exampleName) {
        return () -> new NamingCollector(strategy, featureName, exampleName);
    }

    private NamingCollector(NamingStrategy.Strategy strategy, NamingStrategy.FeatureName featureName, NamingStrategy.ExampleName exampleName) {
        this.strategy = strategy;
        this.featureName = featureName;
        this.exampleName = exampleName;
    }

    @Override
    public void add(Feature feature) {
        if (this.featureName == NamingStrategy.FeatureName.INCLUDE || this.strategy == NamingStrategy.Strategy.SHORT) {
            this.parts.add(feature.getName());
        }
    }

    @Override
    public void add(Rule rule) {
        this.parts.add(rule.getName());
    }

    @Override
    public void add(Scenario scenario) {
        this.scenarioName = scenario.getName();
        this.parts.add(this.scenarioName);
    }

    @Override
    public void add(Examples examples, int index) {
        this.parts.add(examples.getName());
        this.examplesIndex = index;
    }

    @Override
    public void add(TableRow example, int index) {
        this.isExample = true;
        this.parts.add("#" + (this.examplesIndex + 1) + "." + (index + 1));
    }

    @Override
    public void add(Pickle pickle) {
        String pickleName = pickle.getName();
        if (this.scenarioName == null) {
            this.parts.add(pickleName);
            return;
        }
        if (this.isExample) {
            switch (this.exampleName) {
                case NUMBER: {
                    break;
                }
                case NUMBER_AND_PICKLE_IF_PARAMETERIZED: {
                    boolean parameterized;
                    boolean bl = parameterized = !this.scenarioName.equals(pickleName);
                    if (!parameterized) break;
                    String exampleNumber = this.parts.removeLast();
                    this.parts.add(exampleNumber + ": " + pickleName);
                    break;
                }
                case PICKLE: {
                    this.parts.removeLast();
                    this.parts.add(pickleName);
                }
            }
        }
    }

    @Override
    public String finish() {
        if (this.strategy == NamingStrategy.Strategy.SHORT) {
            return this.parts.getLast();
        }
        return this.parts.stream().filter(s -> !s.isEmpty()).collect(Collectors.joining(this.delimiter));
    }
}

