/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.apache.http.protocol;

import io.cucumber.pro.shaded.org.apache.http.HttpConnection;
import io.cucumber.pro.shaded.org.apache.http.HttpException;
import io.cucumber.pro.shaded.org.apache.http.HttpHost;
import io.cucumber.pro.shaded.org.apache.http.HttpInetConnection;
import io.cucumber.pro.shaded.org.apache.http.HttpRequest;
import io.cucumber.pro.shaded.org.apache.http.HttpRequestInterceptor;
import io.cucumber.pro.shaded.org.apache.http.HttpVersion;
import io.cucumber.pro.shaded.org.apache.http.ProtocolException;
import io.cucumber.pro.shaded.org.apache.http.ProtocolVersion;
import io.cucumber.pro.shaded.org.apache.http.annotation.Contract;
import io.cucumber.pro.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.cucumber.pro.shaded.org.apache.http.protocol.HttpContext;
import io.cucumber.pro.shaded.org.apache.http.protocol.HttpCoreContext;
import io.cucumber.pro.shaded.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

