/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import cucumber.runtime.CucumberException;
import io.cucumber.pro.Logger;
import io.cucumber.pro.config.Config;
import io.cucumber.pro.environment.CIEnvironment;
import io.cucumber.pro.results.CucumberProResultsUrlBuilder;
import io.cucumber.pro.results.HTTPResultsPublisher;
import io.cucumber.pro.results.NullResultsPublisher;
import io.cucumber.pro.results.ResultsPublisher;

public class ResultsPublisherFactory {
    public static ResultsPublisher create(Config config, Logger logger, CIEnvironment ciEnvironment) {
        if (ciEnvironment != null) {
            String projectName = config.getString("cucumberpro.projectname");
            if (projectName == null) {
                projectName = ciEnvironment.getProjectName();
            }
            if (projectName == null) {
                throw new CucumberException(String.format("You have to define %s when running on %s", "cucumberpro.projectname", ciEnvironment.toString()));
            }
            String url = CucumberProResultsUrlBuilder.buildCucumberProUrl(config, projectName);
            return new HTTPResultsPublisher(url, config, logger);
        }
        return new NullResultsPublisher();
    }
}

