/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import cucumber.runtime.CucumberException;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.JsonSyntaxException;
import io.cucumber.pro.Logger;
import io.cucumber.pro.config.Config;
import io.cucumber.pro.results.ResultsPublisher;
import io.cucumber.pro.shaded.org.apache.http.HttpResponse;
import io.cucumber.pro.shaded.org.apache.http.StatusLine;
import io.cucumber.pro.shaded.org.apache.http.auth.AuthScope;
import io.cucumber.pro.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import io.cucumber.pro.shaded.org.apache.http.client.HttpClient;
import io.cucumber.pro.shaded.org.apache.http.client.config.RequestConfig;
import io.cucumber.pro.shaded.org.apache.http.client.methods.HttpPost;
import io.cucumber.pro.shaded.org.apache.http.conn.ConnectTimeoutException;
import io.cucumber.pro.shaded.org.apache.http.conn.HttpHostConnectException;
import io.cucumber.pro.shaded.org.apache.http.entity.ContentType;
import io.cucumber.pro.shaded.org.apache.http.entity.StringEntity;
import io.cucumber.pro.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import io.cucumber.pro.shaded.org.apache.http.impl.client.HttpClientBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HTTPResultsPublisher
implements ResultsPublisher {
    private static final Gson GSON = new Gson();
    private static final String CONTENT_TYPE_CUCUMBER_JAVA_RESULTS_JSON = "application/x.cucumber.java.results+json";
    private final String url;
    private final String authToken;
    private final Config config;
    private final Logger logger;

    HTTPResultsPublisher(String url, Config config, Logger logger) {
        this.url = url;
        this.config = config;
        this.authToken = config.getString("cucumberpro.token");
        this.logger = logger;
    }

    @Override
    public void publish(File resultsJsonFile, Map<String, String> env, String profileName, String revision, String branch, String tag) {
        HttpClient client = this.buildHttpClient();
        HttpPost post = new HttpPost(URI.create(this.url));
        try {
            HashMap<String, String> git = new HashMap<String, String>();
            git.put("revision", revision);
            git.put("branch", branch);
            git.put("tag", tag);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("environment", env);
            body.put("cucumberJson", GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(resultsJsonFile), "UTF-8"), List.class));
            body.put("profileName", profileName);
            body.put("git", git);
            String json = GSON.toJson(body);
            post.setEntity(new StringEntity(json, ContentType.create(CONTENT_TYPE_CUCUMBER_JAVA_RESULTS_JSON, "UTF-8")));
            HttpResponse response = client.execute(post);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 400) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                response.getEntity().writeTo(baos);
                String responseBody = new String(baos.toByteArray(), "UTF-8");
                String suggestion = "";
                if (statusCode == 401) {
                    suggestion = String.format("You need to define %s", "cucumberpro.token");
                }
                if (statusCode == 403) {
                    suggestion = String.format("You need to change the value of %s", "cucumberpro.token");
                }
                String message = String.format("Failed to publish results to Cucumber Pro URL: %s, Status: %s\n%s\n%s", this.url, statusLine, responseBody, suggestion);
                this.logger.log(Logger.Level.ERROR, message, new Object[0]);
                throw new CucumberException(message);
            }
            this.logger.log(Logger.Level.INFO, "Published results to Cucumber Pro: " + this.url, new Object[0]);
        }
        catch (ConnectTimeoutException | HttpHostConnectException e) {
            if (this.config.getBoolean("cucumberpro.connection.ignoreerror").booleanValue()) {
                this.logger.log(Logger.Level.WARN, "Failed to publish results to %s\n", this.url);
            }
            throw this.logger.log(e, String.format("Failed to publish results to %s\nYou can set %s to true to treat this as a warning instead of an error", this.url, "cucumberpro.connection.ignoreerror"));
        }
        catch (JsonSyntaxException e) {
            System.err.println("Failed to parse JSON from " + resultsJsonFile.getAbsolutePath());
            throw e;
        }
        catch (IOException e) {
            throw this.logger.log(e, "Unexpected IO Error");
        }
    }

    private HttpClient buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        int timeout = this.config.getInteger("cucumberpro.connection.timeout");
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        if (this.authToken != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.authToken, "");
            provider.setCredentials(AuthScope.ANY, credentials);
            httpClientBuilder.setDefaultCredentialsProvider(provider);
        }
        return httpClientBuilder.build();
    }
}

