/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import cucumber.runtime.CucumberException;
import io.cucumber.pro.config.Config;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public interface Logger {
    public void log(Level var1, String var2, Object ... var3);

    public RuntimeException log(Exception var1, String var2);

    public static class SystemLogger
    implements Logger {
        public final Level level;
        private final PrintWriter stdout;
        private final PrintWriter stderr;
        private final PrintWriter fileWriter;

        SystemLogger(Config config) {
            Level level;
            String name = config.getString("cucumberpro.logging").toUpperCase();
            try {
                level = Level.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                level = Level.WARN;
            }
            try {
                this.stdout = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
                this.stderr = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new CucumberException((Throwable)e);
            }
            if (config.getString("cucumberpro.logfile") != null) {
                try {
                    this.fileWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config.getString("cucumberpro.logfile")), "UTF-8"));
                }
                catch (IOException e) {
                    throw new CucumberException("Failed to create Cucumber Pro log file " + config.getString("cucumberpro.logfile"), (Throwable)e);
                }
            } else {
                this.fileWriter = null;
            }
            this.level = level;
        }

        @Override
        public void log(Level level, String message, Object ... args) {
            if (level.value >= this.level.value) {
                PrintWriter console = level.value >= Level.WARN.value ? this.stderr : this.stdout;
                this.log(console, level, message, args);
                if (this.fileWriter != null) {
                    this.log(this.fileWriter, level, message, args);
                }
            }
        }

        private void log(PrintWriter console, Level level, String message, Object[] args) {
            console.print((Object)level);
            console.print(": ");
            console.format(message, args);
            console.print("\n");
            console.flush();
        }

        @Override
        public RuntimeException log(Exception e, String message) {
            this.log(Level.ERROR, message, new Object[0]);
            return new CucumberException(message, (Throwable)e);
        }
    }

    public static enum Level {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3),
        FATAL(4);

        private final int value;

        private Level(int value) {
            this.value = value;
        }
    }
}

