/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.lib;

import io.cucumber.pro.shaded.org.eclipse.jgit.annotations.NonNull;
import io.cucumber.pro.shaded.org.eclipse.jgit.annotations.Nullable;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.BatchRefUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefRename;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefUpdate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    public static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create() throws IOException;

    public abstract void close();

    public abstract boolean isNameConflicting(String var1) throws IOException;

    @NonNull
    public Collection<String> getConflictingNames(String name) throws IOException {
        Map<String, Ref> allRefs = this.getRefs(ALL);
        int lastSlash = name.lastIndexOf(47);
        while (0 < lastSlash) {
            String needle = name.substring(0, lastSlash);
            if (allRefs.containsKey(needle)) {
                return Collections.singletonList(needle);
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        ArrayList<String> conflicting = new ArrayList<String>();
        String prefix = name + '/';
        for (String existing : allRefs.keySet()) {
            if (!existing.startsWith(prefix)) continue;
            conflicting.add(existing);
        }
        return conflicting;
    }

    @NonNull
    public abstract RefUpdate newUpdate(String var1, boolean var2) throws IOException;

    @NonNull
    public abstract RefRename newRename(String var1, String var2) throws IOException;

    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    @Nullable
    public abstract Ref getRef(String var1) throws IOException;

    @Nullable
    public Ref exactRef(String name) throws IOException {
        Ref ref = this.getRef(name);
        if (ref == null || !name.equals(ref.getName())) {
            return null;
        }
        return ref;
    }

    @NonNull
    public Map<String, Ref> exactRef(String ... refs) throws IOException {
        HashMap<String, Ref> result = new HashMap<String, Ref>(refs.length);
        for (String name : refs) {
            Ref ref = this.exactRef(name);
            if (ref == null) continue;
            result.put(name, ref);
        }
        return result;
    }

    @Nullable
    public Ref firstExactRef(String ... refs) throws IOException {
        for (String name : refs) {
            Ref ref = this.exactRef(name);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }

    @NonNull
    public abstract Map<String, Ref> getRefs(String var1) throws IOException;

    @NonNull
    public abstract List<Ref> getAdditionalRefs() throws IOException;

    @NonNull
    public abstract Ref peel(Ref var1) throws IOException;

    public void refresh() {
    }

    @Nullable
    public static Ref findRef(Map<String, Ref> map, String name) {
        for (String prefix : SEARCH_PATH) {
            String fullname = prefix + name;
            Ref ref = map.get(fullname);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }
}

