/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.lib;

import io.cucumber.pro.shaded.org.eclipse.jgit.lib.BranchConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalkUtils;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository, String branchName) throws IOException {
        String shortBranchName = Repository.shortenRefName(branchName);
        String fullBranchName = "refs/heads/" + shortBranchName;
        BranchConfig branchConfig = new BranchConfig(repository.getConfig(), shortBranchName);
        String trackingBranch = branchConfig.getTrackingBranch();
        if (trackingBranch == null) {
            return null;
        }
        Ref tracking = repository.exactRef(trackingBranch);
        if (tracking == null) {
            return null;
        }
        Ref local = repository.exactRef(fullBranchName);
        if (local == null) {
            return null;
        }
        RevWalk walk = new RevWalk(repository);
        RevCommit localCommit = walk.parseCommit(local.getObjectId());
        RevCommit trackingCommit = walk.parseCommit(tracking.getObjectId());
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(localCommit);
        walk.markStart(trackingCommit);
        RevCommit mergeBase = walk.next();
        walk.reset();
        walk.setRevFilter(RevFilter.ALL);
        int aheadCount = RevWalkUtils.count(walk, localCommit, mergeBase);
        int behindCount = RevWalkUtils.count(walk, trackingCommit, mergeBase);
        return new BranchTrackingStatus(trackingBranch, aheadCount, behindCount);
    }

    private BranchTrackingStatus(String remoteTrackingBranch, int aheadCount, int behindCount) {
        this.remoteTrackingBranch = remoteTrackingBranch;
        this.aheadCount = aheadCount;
        this.behindCount = behindCount;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

