/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file;

import io.cucumber.pro.shaded.org.eclipse.jgit.annotations.Nullable;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.attributes.AttributesNode;
import io.cucumber.pro.shaded.org.eclipse.jgit.attributes.AttributesNodeProvider;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.ConfigInvalidException;
import io.cucumber.pro.shaded.org.eclipse.jgit.events.ConfigChangedEvent;
import io.cucumber.pro.shaded.org.eclipse.jgit.events.ConfigChangedListener;
import io.cucumber.pro.shaded.org.eclipse.jgit.events.IndexChangedEvent;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.FileSnapshot;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.GC;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.GlobalAttributesNode;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.InfoAttributesNode;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.LockFile;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.RefDirectory;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.ReflogReaderImpl;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.BaseRepositoryBuilder;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Constants;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.CoreConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ProgressMonitor;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefDatabase;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ReflogReader;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.storage.file.FileBasedConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import io.cucumber.pro.shaded.org.eclipse.jgit.storage.pack.PackConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.FS;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.FileUtils;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.IO;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.RawParseUtils;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.StringUtils;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.SystemReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class FileRepository
extends Repository {
    private static final String UNNAMED = "Unnamed repository; edit this file to name it for gitweb.";
    private final FileBasedConfig systemConfig = StringUtils.isEmptyOrNull(SystemReader.getInstance().getenv("GIT_CONFIG_NOSYSTEM")) ? SystemReader.getInstance().openSystemConfig(null, this.getFS()) : new FileBasedConfig(null, FS.DETECTED){

        @Override
        public void load() {
        }

        @Override
        public boolean isOutdated() {
            return false;
        }
    };
    private final FileBasedConfig userConfig = SystemReader.getInstance().openUserConfig(this.systemConfig, this.getFS());
    private final FileBasedConfig repoConfig = new FileBasedConfig(this.userConfig, this.getFS().resolve(this.getDirectory(), "config"), this.getFS());
    private final RefDatabase refs;
    private final ObjectDirectory objectDatabase;
    private FileSnapshot snapshot;

    public FileRepository(File gitDir) throws IOException {
        this((BaseRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).setup());
    }

    public FileRepository(String gitDir) throws IOException {
        this(new File(gitDir));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileRepository(BaseRepositoryBuilder options) throws IOException {
        super(options);
        this.loadSystemConfig();
        this.loadUserConfig();
        this.loadRepoConfig();
        this.repoConfig.addChangeListener(new ConfigChangedListener(){

            @Override
            public void onConfigChanged(ConfigChangedEvent event) {
                FileRepository.this.fireEvent(event);
            }
        });
        long repositoryFormatVersion = this.getConfig().getLong("core", null, "repositoryformatversion", 0L);
        String reftype = this.repoConfig.getString("extensions", null, "refStorage");
        if (repositoryFormatVersion >= 1L && reftype != null) {
            if (!StringUtils.equalsIgnoreCase(reftype, "reftree")) throw new IOException(JGitText.get().unknownRepositoryFormat);
            this.refs = new RefTreeDatabase(this, new RefDirectory(this));
        } else {
            this.refs = new RefDirectory(this);
        }
        this.objectDatabase = new ObjectDirectory(this.repoConfig, options.getObjectDirectory(), options.getAlternateObjectDirectories(), this.getFS(), new File(this.getDirectory(), "shallow"));
        if (this.objectDatabase.exists() && repositoryFormatVersion > 1L) {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRepositoryFormat2, repositoryFormatVersion));
        }
        if (this.isBare()) return;
        this.snapshot = FileSnapshot.save(this.getIndexFile());
    }

    private void loadSystemConfig() throws IOException {
        try {
            this.systemConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(MessageFormat.format(JGitText.get().systemConfigFileInvalid, this.systemConfig.getFile().getAbsolutePath(), e1));
            e2.initCause(e1);
            throw e2;
        }
    }

    private void loadUserConfig() throws IOException {
        try {
            this.userConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(MessageFormat.format(JGitText.get().userConfigFileInvalid, this.userConfig.getFile().getAbsolutePath(), e1));
            e2.initCause(e1);
            throw e2;
        }
    }

    private void loadRepoConfig() throws IOException {
        try {
            this.repoConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(JGitText.get().unknownRepositoryFormat);
            e2.initCause(e1);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(boolean bare) throws IOException {
        boolean fileMode;
        FileBasedConfig cfg = this.getConfig();
        if (cfg.getFile().exists()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, this.getDirectory()));
        }
        FileUtils.mkdirs(this.getDirectory(), true);
        CoreConfig.HideDotFiles hideDotFiles = this.getConfig().getEnum("core", null, "hidedotfiles", CoreConfig.HideDotFiles.DOTGITONLY);
        if (hideDotFiles != CoreConfig.HideDotFiles.FALSE && !this.isBare() && this.getDirectory().getName().startsWith(".")) {
            this.getFS().setHidden(this.getDirectory(), true);
        }
        this.refs.create();
        this.objectDatabase.create();
        FileUtils.mkdir(new File(this.getDirectory(), "branches"));
        FileUtils.mkdir(new File(this.getDirectory(), "hooks"));
        RefUpdate head = this.updateRef("HEAD");
        head.disableRefLog();
        head.link("refs/heads/master");
        if (this.getFS().supportsExecute()) {
            File tmp = File.createTempFile("try", "execute", this.getDirectory());
            this.getFS().setExecute(tmp, true);
            boolean on = this.getFS().canExecute(tmp);
            this.getFS().setExecute(tmp, false);
            boolean off = this.getFS().canExecute(tmp);
            FileUtils.delete(tmp);
            fileMode = on && !off;
        } else {
            fileMode = false;
        }
        CoreConfig.SymLinks symLinks = CoreConfig.SymLinks.FALSE;
        if (this.getFS().supportsSymlinks()) {
            File tmp = new File(this.getDirectory(), "tmplink");
            try {
                this.getFS().createSymLink(tmp, "target");
                symLinks = null;
                FileUtils.delete(tmp);
            }
            catch (IOException off) {
                // empty catch block
            }
        }
        if (symLinks != null) {
            cfg.setString("core", null, "symlinks", symLinks.name().toLowerCase(Locale.ROOT));
        }
        cfg.setInt("core", null, "repositoryformatversion", 0);
        cfg.setBoolean("core", null, "filemode", fileMode);
        if (bare) {
            cfg.setBoolean("core", null, "bare", true);
        }
        cfg.setBoolean("core", null, "logallrefupdates", !bare);
        if (SystemReader.getInstance().isMacOS()) {
            cfg.setBoolean("core", null, "precomposeunicode", true);
        }
        if (!bare) {
            File workTree = this.getWorkTree();
            if (!this.getDirectory().getParentFile().equals(workTree)) {
                cfg.setString("core", null, "worktree", this.getWorkTree().getAbsolutePath());
                LockFile dotGitLockFile = new LockFile(new File(workTree, ".git"));
                try {
                    if (dotGitLockFile.lock()) {
                        dotGitLockFile.write(Constants.encode("gitdir: " + this.getDirectory().getAbsolutePath()));
                        dotGitLockFile.commit();
                    }
                }
                finally {
                    dotGitLockFile.unlock();
                }
            }
        }
        cfg.save();
    }

    public File getObjectsDirectory() {
        return this.objectDatabase.getDirectory();
    }

    @Override
    public ObjectDirectory getObjectDatabase() {
        return this.objectDatabase;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refs;
    }

    @Override
    public FileBasedConfig getConfig() {
        if (this.systemConfig.isOutdated()) {
            try {
                this.loadSystemConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.userConfig.isOutdated()) {
            try {
                this.loadUserConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.repoConfig.isOutdated()) {
            try {
                this.loadRepoConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.repoConfig;
    }

    @Override
    @Nullable
    public String getGitwebDescription() throws IOException {
        String d;
        try {
            d = RawParseUtils.decode(IO.readFully(this.descriptionFile()));
        }
        catch (FileNotFoundException err) {
            return null;
        }
        if (d != null && ((d = d.trim()).isEmpty() || UNNAMED.equals(d))) {
            return null;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGitwebDescription(@Nullable String description) throws IOException {
        String old = this.getGitwebDescription();
        if (Objects.equals(old, description)) {
            return;
        }
        File path = this.descriptionFile();
        LockFile lock = new LockFile(path);
        if (!lock.lock()) {
            throw new IOException(MessageFormat.format(JGitText.get().lockError, path.getAbsolutePath()));
        }
        try {
            String d = description;
            if (d != null) {
                if (!(d = d.trim()).isEmpty()) {
                    d = d + '\n';
                }
            } else {
                d = "";
            }
            lock.write(Constants.encode(d));
            lock.commit();
        }
        finally {
            lock.unlock();
        }
    }

    private File descriptionFile() {
        return new File(this.getDirectory(), "description");
    }

    @Override
    public Set<ObjectId> getAdditionalHaves() {
        return this.getAdditionalHaves(null);
    }

    private Set<ObjectId> getAdditionalHaves(Set<ObjectDirectory.AlternateHandle.Id> skips) {
        HashSet<ObjectId> r = new HashSet<ObjectId>();
        skips = this.objectDatabase.addMe(skips);
        for (ObjectDirectory.AlternateHandle d : this.objectDatabase.myAlternates()) {
            if (!(d instanceof ObjectDirectory.AlternateRepository) || skips.contains(d.getId())) continue;
            FileRepository repo = ((ObjectDirectory.AlternateRepository)d).repository;
            for (Ref ref : repo.getAllRefs().values()) {
                if (ref.getObjectId() != null) {
                    r.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                r.add(ref.getPeeledObjectId());
            }
            r.addAll(repo.getAdditionalHaves(skips));
        }
        return r;
    }

    public void openPack(File pack) throws IOException {
        this.objectDatabase.openPack(pack);
    }

    @Override
    public void scanForRepoChanges() throws IOException {
        this.getRefDatabase().getRefs("");
        this.detectIndexChanges();
    }

    private void detectIndexChanges() {
        if (this.isBare()) {
            return;
        }
        File indexFile = this.getIndexFile();
        if (this.snapshot == null) {
            this.snapshot = FileSnapshot.save(indexFile);
        } else if (this.snapshot.isModified(indexFile)) {
            this.notifyIndexChanged();
        }
    }

    @Override
    public void notifyIndexChanged() {
        this.snapshot = FileSnapshot.save(this.getIndexFile());
        this.fireEvent(new IndexChangedEvent());
    }

    @Override
    public ReflogReader getReflogReader(String refName) throws IOException {
        Ref ref = this.findRef(refName);
        if (ref != null) {
            return new ReflogReaderImpl(this, ref.getName());
        }
        return null;
    }

    @Override
    public AttributesNodeProvider createAttributesNodeProvider() {
        return new AttributesNodeProviderImpl(this);
    }

    private boolean shouldAutoDetach() {
        return this.getConfig().getBoolean("gc", "autoDetach", true);
    }

    @Override
    public void autoGC(ProgressMonitor monitor) {
        GC gc = new GC(this);
        gc.setPackConfig(new PackConfig(this));
        gc.setProgressMonitor(monitor);
        gc.setAuto(true);
        gc.setBackground(this.shouldAutoDetach());
        try {
            gc.gc();
        }
        catch (IOException | ParseException e) {
            throw new JGitInternalException(JGitText.get().gcFailed, e);
        }
    }

    static class AttributesNodeProviderImpl
    implements AttributesNodeProvider {
        private AttributesNode infoAttributesNode;
        private AttributesNode globalAttributesNode;

        protected AttributesNodeProviderImpl(Repository repo) {
            this.infoAttributesNode = new InfoAttributesNode(repo);
            this.globalAttributesNode = new GlobalAttributesNode(repo);
        }

        @Override
        public AttributesNode getInfoAttributesNode() throws IOException {
            if (this.infoAttributesNode instanceof InfoAttributesNode) {
                this.infoAttributesNode = ((InfoAttributesNode)this.infoAttributesNode).load();
            }
            return this.infoAttributesNode;
        }

        @Override
        public AttributesNode getGlobalAttributesNode() throws IOException {
            if (this.globalAttributesNode instanceof GlobalAttributesNode) {
                this.globalAttributesNode = ((GlobalAttributesNode)this.globalAttributesNode).load();
            }
            return this.globalAttributesNode;
        }

        static void loadRulesFromFile(AttributesNode r, File attrs) throws FileNotFoundException, IOException {
            if (attrs.exists()) {
                try (FileInputStream in = new FileInputStream(attrs);){
                    r.parse(in);
                }
            }
        }
    }
}

