/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file;

import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.ByteWindow;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.PackFile;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class ByteArrayWindow
extends ByteWindow {
    private final byte[] array;

    ByteArrayWindow(PackFile pack, long o, byte[] b) {
        super(pack, o, b.length);
        this.array = b;
    }

    @Override
    protected int copy(int p, byte[] b, int o, int n) {
        n = Math.min(this.array.length - p, n);
        System.arraycopy(this.array, p, b, o, n);
        return n;
    }

    @Override
    protected int setInput(int pos, Inflater inf) throws DataFormatException {
        int n = this.array.length - pos;
        inf.setInput(this.array, pos, n);
        return n;
    }

    void crc32(CRC32 out, long pos, int cnt) {
        out.update(this.array, (int)(pos - this.start), cnt);
    }

    @Override
    void write(PackOutputStream out, long pos, int cnt) throws IOException {
        int ptr = (int)(pos - this.start);
        out.write(this.array, ptr, cnt);
    }

    void check(Inflater inf, byte[] tmp, long pos, int cnt) throws DataFormatException {
        inf.setInput(this.array, (int)(pos - this.start), cnt);
        while (inf.inflate(tmp, 0, tmp.length) > 0) {
        }
    }
}

