/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.diff;

import io.cucumber.pro.shaded.org.eclipse.jgit.diff.DiffAlgorithm;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.Edit;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.EditList;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.HashedSequence;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.HashedSequenceComparator;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.HistogramDiffIndex;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.LowLevelDiffAlgorithm;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.MyersDiff;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.Sequence;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.Subsequence;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.SubsequenceComparator;
import java.util.ArrayList;
import java.util.List;

public class HistogramDiff
extends LowLevelDiffAlgorithm {
    DiffAlgorithm fallback = MyersDiff.INSTANCE;
    int maxChainLength = 64;

    public void setFallbackAlgorithm(DiffAlgorithm alg) {
        this.fallback = alg;
    }

    public void setMaxChainLength(int maxLen) {
        this.maxChainLength = maxLen;
    }

    @Override
    public <S extends Sequence> void diffNonCommon(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b, Edit region) {
        new State<S>(edits, cmp, a, b).diffRegion(region);
    }

    private class State<S extends Sequence> {
        private final HashedSequenceComparator<S> cmp;
        private final HashedSequence<S> a;
        private final HashedSequence<S> b;
        private final List<Edit> queue = new ArrayList<Edit>();
        final EditList edits;

        State(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b) {
            this.cmp = cmp;
            this.a = a;
            this.b = b;
            this.edits = edits;
        }

        void diffRegion(Edit r) {
            this.diffReplace(r);
            while (!this.queue.isEmpty()) {
                this.diff(this.queue.remove(this.queue.size() - 1));
            }
        }

        private void diffReplace(Edit r) {
            Edit lcs = new HistogramDiffIndex<S>(HistogramDiff.this.maxChainLength, this.cmp, this.a, this.b, r).findLongestCommonSequence();
            if (lcs != null) {
                if (lcs.isEmpty()) {
                    this.edits.add(r);
                } else {
                    this.queue.add(r.after(lcs));
                    this.queue.add(r.before(lcs));
                }
            } else if (HistogramDiff.this.fallback instanceof LowLevelDiffAlgorithm) {
                LowLevelDiffAlgorithm fb = (LowLevelDiffAlgorithm)HistogramDiff.this.fallback;
                fb.diffNonCommon(this.edits, this.cmp, this.a, this.b, r);
            } else if (HistogramDiff.this.fallback != null) {
                SubsequenceComparator<HashedSequence<S>> cs = this.subcmp();
                Subsequence<HashedSequence<S>> as = Subsequence.a(this.a, r);
                Subsequence<HashedSequence<S>> bs = Subsequence.b(this.b, r);
                EditList res = HistogramDiff.this.fallback.diffNonCommon(cs, as, bs);
                this.edits.addAll(Subsequence.toBase(res, as, bs));
            } else {
                this.edits.add(r);
            }
        }

        private void diff(Edit r) {
            switch (r.getType()) {
                case INSERT: 
                case DELETE: {
                    this.edits.add(r);
                    break;
                }
                case REPLACE: {
                    if (r.getLengthA() == 1 && r.getLengthB() == 1) {
                        this.edits.add(r);
                        break;
                    }
                    this.diffReplace(r);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private SubsequenceComparator<HashedSequence<S>> subcmp() {
            return new SubsequenceComparator<HashedSequence<S>>(this.cmp);
        }
    }
}

