/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.StoredConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.RemoteConfig;
import java.io.IOException;
import java.net.URISyntaxException;

public class RemoteRemoveCommand
extends GitCommand<RemoteConfig> {
    private String name;

    protected RemoteRemoveCommand(Repository repo) {
        super(repo);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            config.unsetSection("remote", this.name);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

