/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.documentation;

import cucumber.runtime.CucumberException;
import io.cucumber.pro.Logger;
import io.cucumber.pro.config.Config;
import io.cucumber.pro.documentation.DocumentationPublisher;
import io.cucumber.pro.documentation.JschLogger;
import io.cucumber.pro.shaded.com.jcraft.jsch.HostKey;
import io.cucumber.pro.shaded.com.jcraft.jsch.IdentityRepository;
import io.cucumber.pro.shaded.com.jcraft.jsch.JSch;
import io.cucumber.pro.shaded.com.jcraft.jsch.JSchException;
import io.cucumber.pro.shaded.com.jcraft.jsch.Session;
import io.cucumber.pro.shaded.com.jcraft.jsch.agentproxy.AgentProxyException;
import io.cucumber.pro.shaded.com.jcraft.jsch.agentproxy.Connector;
import io.cucumber.pro.shaded.com.jcraft.jsch.agentproxy.ConnectorFactory;
import io.cucumber.pro.shaded.com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.FetchCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.Git;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.PushCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.TransportCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.TransportConfigCallback;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.StoredConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.TextProgressMonitor;
import io.cucumber.pro.shaded.org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.FetchResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.JschConfigSessionFactory;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.OpenSshConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.OperationResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.PushResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.RefSpec;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.SshSessionFactory;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.SshTransport;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.Transport;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.FS;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class GitDocumentationPublisher
implements DocumentationPublisher {
    private final RemoteSpec pushSpec;
    private final Logger logger;
    private final boolean ignoreConnectionError;
    private final String fetchRemoteName;
    private final boolean fetchFromSource;

    GitDocumentationPublisher(RemoteSpec pushSpec, Config config, Logger logger) {
        this.pushSpec = pushSpec;
        this.logger = logger;
        JSch.setLogger(new JschLogger(logger));
        this.ignoreConnectionError = config.getBoolean("cucumberpro.connection.ignoreerror");
        this.fetchRemoteName = config.getString("cucumberpro.git.source.remote");
        this.fetchFromSource = config.getBoolean("cucumberpro.git.source.fetch");
    }

    private static <C extends GitCommand, R> void configureSsh(RemoteSpec remoteSpec, TransportCommand<C, R> push) throws JSchException {
        final SshSessionFactory sshSessionFactory = GitDocumentationPublisher.getSshSessionFactory(remoteSpec);
        push.setTransportConfigCallback(new TransportConfigCallback(){

            @Override
            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory(sshSessionFactory);
            }
        });
    }

    static Git getGit() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).findGitDir()).setMustExist(true)).build();
        return new Git(repository);
    }

    private static SshSessionFactory getSshSessionFactory(final RemoteSpec remoteSpec) throws JSchException {
        return new JschConfigSessionFactory(){

            @Override
            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setPort(remoteSpec.port);
            }

            @Override
            protected JSch getJSch(OpenSshConfig.Host host, FS fs) throws JSchException {
                JSch jsch = super.createDefaultJSch(fs);
                if (remoteSpec.hostKey != null) {
                    HostKey key = new HostKey(host.getHostName(), DatatypeConverter.parseBase64Binary((String)remoteSpec.hostKey));
                    jsch.getHostKeyRepository().add(key, null);
                }
                jsch.setIdentityRepository(GitDocumentationPublisher.getIdentityRepository());
                return jsch;
            }
        };
    }

    private static IdentityRepository getIdentityRepository() throws JSchException {
        try {
            ConnectorFactory connectorFactory = ConnectorFactory.getDefault();
            Connector connector = connectorFactory.createConnector();
            return new RemoteIdentityRepository(connector);
        }
        catch (AgentProxyException e) {
            throw new JSchException("Failed to configure SSH Agent", e);
        }
    }

    @Override
    public void publish() {
        try {
            Git git = GitDocumentationPublisher.getGit();
            if (this.fetchFromSource) {
                this.fetch(git, this.fetchRemoteName);
            }
            this.push(git);
        }
        catch (IOException e) {
            throw new CucumberException("IO error", (Throwable)e);
        }
    }

    void fetch(Git git, String fetchRemoteName) throws IOException {
        String fetchRemote = git.getRepository().getConfig().getString("remote", fetchRemoteName, "url");
        RemoteSpec fetchSpec = new RemoteSpec(fetchRemote, 22, null);
        try {
            this.fetch0(git, fetchSpec, fetchRemoteName);
            this.logger.log(Logger.Level.INFO, "Fetched all commits from " + fetchSpec.remote, new Object[0]);
        }
        catch (GitAPIException e) {
            if (this.ignoreConnectionError) {
                this.logger.log(Logger.Level.INFO, "Failed to fetch commits from %s\n", fetchSpec.remote);
            }
            throw new CucumberException(String.format("Failed to fetch commits from %s\nYou can set %s to true to treat this as a warning instead of an error", fetchSpec.remote, "cucumberpro.connection.ignoreerror"), (Throwable)e);
        }
        catch (JSchException e) {
            throw new CucumberException("SSH error", (Throwable)e);
        }
    }

    private void push(Git git) throws IOException {
        try {
            this.push0(git);
            this.logger.log(Logger.Level.INFO, "Published documentation to Cucumber Pro: " + this.pushSpec.remote, new Object[0]);
        }
        catch (GitAPIException e) {
            if (this.ignoreConnectionError) {
                this.logger.log(Logger.Level.WARN, "Failed to publish documentation to %s\n", this.pushSpec.remote);
            }
            throw new CucumberException(String.format("Failed to publish documentation to %s\nYou can set %s to true to treat this as a warning instead of an error", this.pushSpec.remote, "cucumberpro.connection.ignoreerror"), (Throwable)e);
        }
        catch (JSchException e) {
            throw new CucumberException("SSH error", (Throwable)e);
        }
    }

    private void fetch0(Git git, RemoteSpec fetchSpec, String fetchRemoteName) throws JSchException, GitAPIException {
        FetchCommand fetch = git.fetch().setCheckFetchedObjects(true);
        fetch.setProgressMonitor(new TextProgressMonitor());
        fetch.setRemote(fetchSpec.remote);
        StoredConfig config = git.getRepository().getConfig();
        List<RefSpec> refSpecs = config.getRefSpecs("remote", fetchRemoteName, "fetch");
        fetch.setRefSpecs(refSpecs);
        GitDocumentationPublisher.configureSsh(fetchSpec, fetch);
        FetchResult result = fetch.call();
        this.logResult(result);
    }

    private void push0(Git git) throws IOException, GitAPIException, JSchException {
        PushCommand push = git.push();
        push.setProgressMonitor(new TextProgressMonitor());
        push.setRemote(this.pushSpec.remote);
        GitDocumentationPublisher.configureSsh(this.pushSpec, push);
        Object result = push.call();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            PushResult pushResult = (PushResult)iterator.next();
            this.logResult(pushResult);
        }
    }

    private void logResult(OperationResult result) {
        this.logger.log(Logger.Level.INFO, result.getMessages(), new Object[0]);
    }

    static class RemoteSpec {
        private final String remote;
        private final int port;
        private final String hostKey;

        RemoteSpec(String remote, int port, String hostKey) {
            this.remote = remote;
            this.port = port;
            this.hostKey = hostKey;
        }
    }
}

